@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.TargetArgs.builder
import com.pulumi.azurenative.databasewatcher.kotlin.enums.TargetAuthenticationType
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.VaultSecretArgs
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.VaultSecretArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### Targets_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var target = new AzureNative.DatabaseWatcher.Target("target", new()
 *     {
 *         ConnectionServerName = "sqlServero1ihe2",
 *         ResourceGroupName = "apiTest-ddat4p",
 *         TargetAuthenticationType = AzureNative.DatabaseWatcher.TargetAuthenticationType.Aad,
 *         TargetName = "monitoringh22eed",
 *         TargetType = "SqlDb",
 *         WatcherName = "databasemo3ej9ih",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databasewatcher/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasewatcher.NewTarget(ctx, "target", &databasewatcher.TargetArgs{
 * 			ConnectionServerName:     pulumi.String("sqlServero1ihe2"),
 * 			ResourceGroupName:        pulumi.String("apiTest-ddat4p"),
 * 			TargetAuthenticationType: pulumi.String(databasewatcher.TargetAuthenticationTypeAad),
 * 			TargetName:               pulumi.String("monitoringh22eed"),
 * 			TargetType:               pulumi.String("SqlDb"),
 * 			WatcherName:              pulumi.String("databasemo3ej9ih"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databasewatcher.Target;
 * import com.pulumi.azurenative.databasewatcher.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var target = new Target("target", TargetArgs.builder()
 *             .connectionServerName("sqlServero1ihe2")
 *             .resourceGroupName("apiTest-ddat4p")
 *             .targetAuthenticationType("Aad")
 *             .targetName("monitoringh22eed")
 *             .targetType("SqlDb")
 *             .watcherName("databasemo3ej9ih")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databasewatcher:Target monitoringh22eed /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DatabaseWatcher/watchers/{watcherName}/targets/{targetName}
 * ```
 * @property connectionServerName The server name to use in the connection string when connecting to a target. Port number and instance name must be specified separately.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property targetAuthenticationType The type of authentication to use when connecting to a target.
 * @property targetName The target resource name.
 * @property targetType Discriminator property for TargetProperties.
 * @property targetVault To use SQL authentication when connecting to targets, specify the vault where the login name and password secrets are stored.
 * @property watcherName The database watcher name.
 */
public data class TargetArgs(
    public val connectionServerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val targetAuthenticationType: Output<Either<String, TargetAuthenticationType>>? = null,
    public val targetName: Output<String>? = null,
    public val targetType: Output<String>? = null,
    public val targetVault: Output<VaultSecretArgs>? = null,
    public val watcherName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.TargetArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.TargetArgs =
        com.pulumi.azurenative.databasewatcher.TargetArgs.builder()
            .connectionServerName(connectionServerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetAuthenticationType(
                targetAuthenticationType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetName(targetName?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 }))
            .targetVault(targetVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .watcherName(watcherName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetArgs].
 */
@PulumiTagMarker
public class TargetArgsBuilder internal constructor() {
    private var connectionServerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var targetAuthenticationType: Output<Either<String, TargetAuthenticationType>>? = null

    private var targetName: Output<String>? = null

    private var targetType: Output<String>? = null

    private var targetVault: Output<VaultSecretArgs>? = null

    private var watcherName: Output<String>? = null

    /**
     * @param value The server name to use in the connection string when connecting to a target. Port number and instance name must be specified separately.
     */
    @JvmName("repwyogqnseyupja")
    public suspend fun connectionServerName(`value`: Output<String>) {
        this.connectionServerName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hucxrwpjqgvimjfu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The type of authentication to use when connecting to a target.
     */
    @JvmName("fcqjcevhvvtxoomq")
    public suspend
    fun targetAuthenticationType(`value`: Output<Either<String, TargetAuthenticationType>>) {
        this.targetAuthenticationType = value
    }

    /**
     * @param value The target resource name.
     */
    @JvmName("richcouwustpsiqf")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value Discriminator property for TargetProperties.
     */
    @JvmName("jfbghlpbamhrgjgu")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value To use SQL authentication when connecting to targets, specify the vault where the login name and password secrets are stored.
     */
    @JvmName("xlchpbxgwefwyxgn")
    public suspend fun targetVault(`value`: Output<VaultSecretArgs>) {
        this.targetVault = value
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("cvmqrgervvhynvbj")
    public suspend fun watcherName(`value`: Output<String>) {
        this.watcherName = value
    }

    /**
     * @param value The server name to use in the connection string when connecting to a target. Port number and instance name must be specified separately.
     */
    @JvmName("senfsxkhwewtrfpp")
    public suspend fun connectionServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionServerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mywlvskljahqdono")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The type of authentication to use when connecting to a target.
     */
    @JvmName("axebakglianrscji")
    public suspend fun targetAuthenticationType(`value`: Either<String, TargetAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAuthenticationType = mapped
    }

    /**
     * @param value The type of authentication to use when connecting to a target.
     */
    @JvmName("wrbuucepwckbtrjg")
    public fun targetAuthenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TargetAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAuthenticationType = mapped
    }

    /**
     * @param value The type of authentication to use when connecting to a target.
     */
    @JvmName("whvtxwacffvejpcr")
    public fun targetAuthenticationType(`value`: TargetAuthenticationType) {
        val toBeMapped = Either.ofRight<String, TargetAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAuthenticationType = mapped
    }

    /**
     * @param value The target resource name.
     */
    @JvmName("fpavlvrigduryyiu")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    /**
     * @param value Discriminator property for TargetProperties.
     */
    @JvmName("hinlmfpwilipagml")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value To use SQL authentication when connecting to targets, specify the vault where the login name and password secrets are stored.
     */
    @JvmName("popkedngcltklywb")
    public suspend fun targetVault(`value`: VaultSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVault = mapped
    }

    /**
     * @param argument To use SQL authentication when connecting to targets, specify the vault where the login name and password secrets are stored.
     */
    @JvmName("sdijrksmocfymjef")
    public suspend fun targetVault(argument: suspend VaultSecretArgsBuilder.() -> Unit) {
        val toBeMapped = VaultSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetVault = mapped
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("ufqmvhfglkilyxhk")
    public suspend fun watcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watcherName = mapped
    }

    internal fun build(): TargetArgs = TargetArgs(
        connectionServerName = connectionServerName,
        resourceGroupName = resourceGroupName,
        targetAuthenticationType = targetAuthenticationType,
        targetName = targetName,
        targetType = targetType,
        targetVault = targetVault,
        watcherName = watcherName,
    )
}
