@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.kotlin.outputs.DatastoreResponse
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.DatastoreResponse.Companion.toKotlin as datastoreResponseToKotlin
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Watcher].
 */
@PulumiTagMarker
public class WatcherResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WatcherArgs = WatcherArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WatcherArgsBuilder.() -> Unit) {
        val builder = WatcherArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Watcher {
        val builtJavaResource = com.pulumi.azurenative.databasewatcher.Watcher(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Watcher(builtJavaResource)
    }
}

/**
 * The DatabaseWatcherProviderHub resource.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### Watchers_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watcher = new AzureNative.DatabaseWatcher.Watcher("watcher", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "apiTest-ddat4p",
 *         WatcherName = "databasemo3ej9ih",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databasewatcher/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasewatcher.NewWatcher(ctx, "watcher", &databasewatcher.WatcherArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("apiTest-ddat4p"),
 * 			WatcherName:       pulumi.String("databasemo3ej9ih"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databasewatcher.Watcher;
 * import com.pulumi.azurenative.databasewatcher.WatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watcher = new Watcher("watcher", WatcherArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("apiTest-ddat4p")
 *             .watcherName("databasemo3ej9ih")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databasewatcher:Watcher databasemo3ej9ih /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DatabaseWatcher/watchers/{watcherName}
 * ```
 */
public class Watcher internal constructor(
    override val javaResource: com.pulumi.azurenative.databasewatcher.Watcher,
) : KotlinCustomResource(javaResource, WatcherMapper) {
    /**
     * The data store for collected monitoring data.
     */
    public val datastore: Output<DatastoreResponse>?
        get() = javaResource.datastore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    datastoreResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource watcher.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The monitoring collection status of the watcher.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WatcherMapper : ResourceMapper<Watcher> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databasewatcher.Watcher::class == javaResource::class

    override fun map(javaResource: Resource): Watcher = Watcher(
        javaResource as
            com.pulumi.azurenative.databasewatcher.Watcher,
    )
}

/**
 * @see [Watcher].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Watcher].
 */
public suspend fun watcher(name: String, block: suspend WatcherResourceBuilder.() -> Unit):
    Watcher {
    val builder = WatcherResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Watcher].
 * @param name The _unique_ name of the resulting resource.
 */
public fun watcher(name: String): Watcher {
    val builder = WatcherResourceBuilder()
    builder.name(name)
    return builder.build()
}
