@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.WatcherArgs.builder
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.DatastoreArgs
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.DatastoreArgsBuilder
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.databasewatcher.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The DatabaseWatcherProviderHub resource.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### Watchers_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watcher = new AzureNative.DatabaseWatcher.Watcher("watcher", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "apiTest-ddat4p",
 *         WatcherName = "databasemo3ej9ih",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databasewatcher/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasewatcher.NewWatcher(ctx, "watcher", &databasewatcher.WatcherArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("apiTest-ddat4p"),
 * 			WatcherName:       pulumi.String("databasemo3ej9ih"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databasewatcher.Watcher;
 * import com.pulumi.azurenative.databasewatcher.WatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watcher = new Watcher("watcher", WatcherArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("apiTest-ddat4p")
 *             .watcherName("databasemo3ej9ih")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databasewatcher:Watcher databasemo3ej9ih /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DatabaseWatcher/watchers/{watcherName}
 * ```
 * @property datastore The data store for collected monitoring data.
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property watcherName The database watcher name.
 */
public data class WatcherArgs(
    public val datastore: Output<DatastoreArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val watcherName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.WatcherArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.WatcherArgs =
        com.pulumi.azurenative.databasewatcher.WatcherArgs.builder()
            .datastore(datastore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .watcherName(watcherName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WatcherArgs].
 */
@PulumiTagMarker
public class WatcherArgsBuilder internal constructor() {
    private var datastore: Output<DatastoreArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var watcherName: Output<String>? = null

    /**
     * @param value The data store for collected monitoring data.
     */
    @JvmName("ctflrvolmwxromps")
    public suspend fun datastore(`value`: Output<DatastoreArgs>) {
        this.datastore = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("afxmbxqwxoslynss")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bapwninfiwpigthu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wbuwiovvmtdtjpmj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jmnwtxbgfofcfuis")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("mhbkeoafdgasrydm")
    public suspend fun watcherName(`value`: Output<String>) {
        this.watcherName = value
    }

    /**
     * @param value The data store for collected monitoring data.
     */
    @JvmName("niqigobopxlgcqrb")
    public suspend fun datastore(`value`: DatastoreArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastore = mapped
    }

    /**
     * @param argument The data store for collected monitoring data.
     */
    @JvmName("kfxerlgfrghyjdaf")
    public suspend fun datastore(argument: suspend DatastoreArgsBuilder.() -> Unit) {
        val toBeMapped = DatastoreArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.datastore = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("wumxyqdbbvvnujdk")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("jxkaijuietjukmgt")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ksdwtasvowqdgvuu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wvldupsagsvoqama")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vljhrsuhtiqhtjot")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kdbufiwabemhgbmo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("pfthvtaahmhhhoxg")
    public suspend fun watcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watcherName = mapped
    }

    internal fun build(): WatcherArgs = WatcherArgs(
        datastore = datastore,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        watcherName = watcherName,
    )
}
