@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.inputs

import com.pulumi.azurenative.databasewatcher.inputs.DatastoreArgs.builder
import com.pulumi.azurenative.databasewatcher.kotlin.enums.KustoOfferingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a data store.
 * @property adxClusterResourceId The Azure ResourceId of an Azure Data Explorer cluster.
 * @property kustoClusterDisplayName The Kusto cluster display name.
 * @property kustoClusterUri The Kusto cluster URI.
 * @property kustoDataIngestionUri The Kusto data ingestion URI.
 * @property kustoDatabaseName The name of a Kusto database.
 * @property kustoManagementUrl The Kusto management URL.
 * @property kustoOfferingType The type of a Kusto offering.
 */
public data class DatastoreArgs(
    public val adxClusterResourceId: Output<String>? = null,
    public val kustoClusterDisplayName: Output<String>? = null,
    public val kustoClusterUri: Output<String>,
    public val kustoDataIngestionUri: Output<String>,
    public val kustoDatabaseName: Output<String>,
    public val kustoManagementUrl: Output<String>,
    public val kustoOfferingType: Output<Either<String, KustoOfferingType>>,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.inputs.DatastoreArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.inputs.DatastoreArgs =
        com.pulumi.azurenative.databasewatcher.inputs.DatastoreArgs.builder()
            .adxClusterResourceId(adxClusterResourceId?.applyValue({ args0 -> args0 }))
            .kustoClusterDisplayName(kustoClusterDisplayName?.applyValue({ args0 -> args0 }))
            .kustoClusterUri(kustoClusterUri.applyValue({ args0 -> args0 }))
            .kustoDataIngestionUri(kustoDataIngestionUri.applyValue({ args0 -> args0 }))
            .kustoDatabaseName(kustoDatabaseName.applyValue({ args0 -> args0 }))
            .kustoManagementUrl(kustoManagementUrl.applyValue({ args0 -> args0 }))
            .kustoOfferingType(
                kustoOfferingType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DatastoreArgs].
 */
@PulumiTagMarker
public class DatastoreArgsBuilder internal constructor() {
    private var adxClusterResourceId: Output<String>? = null

    private var kustoClusterDisplayName: Output<String>? = null

    private var kustoClusterUri: Output<String>? = null

    private var kustoDataIngestionUri: Output<String>? = null

    private var kustoDatabaseName: Output<String>? = null

    private var kustoManagementUrl: Output<String>? = null

    private var kustoOfferingType: Output<Either<String, KustoOfferingType>>? = null

    /**
     * @param value The Azure ResourceId of an Azure Data Explorer cluster.
     */
    @JvmName("yqnrifaawngrpwsw")
    public suspend fun adxClusterResourceId(`value`: Output<String>) {
        this.adxClusterResourceId = value
    }

    /**
     * @param value The Kusto cluster display name.
     */
    @JvmName("xsyjmgrxkqofubex")
    public suspend fun kustoClusterDisplayName(`value`: Output<String>) {
        this.kustoClusterDisplayName = value
    }

    /**
     * @param value The Kusto cluster URI.
     */
    @JvmName("dahipxcvvcupcklh")
    public suspend fun kustoClusterUri(`value`: Output<String>) {
        this.kustoClusterUri = value
    }

    /**
     * @param value The Kusto data ingestion URI.
     */
    @JvmName("tyxvlwjiuahjhrjg")
    public suspend fun kustoDataIngestionUri(`value`: Output<String>) {
        this.kustoDataIngestionUri = value
    }

    /**
     * @param value The name of a Kusto database.
     */
    @JvmName("obxbdwjkkwcwoygs")
    public suspend fun kustoDatabaseName(`value`: Output<String>) {
        this.kustoDatabaseName = value
    }

    /**
     * @param value The Kusto management URL.
     */
    @JvmName("myyvxxtpngdheobv")
    public suspend fun kustoManagementUrl(`value`: Output<String>) {
        this.kustoManagementUrl = value
    }

    /**
     * @param value The type of a Kusto offering.
     */
    @JvmName("ymgmblddwwvfawnn")
    public suspend fun kustoOfferingType(`value`: Output<Either<String, KustoOfferingType>>) {
        this.kustoOfferingType = value
    }

    /**
     * @param value The Azure ResourceId of an Azure Data Explorer cluster.
     */
    @JvmName("vfeysckbixwcvonh")
    public suspend fun adxClusterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adxClusterResourceId = mapped
    }

    /**
     * @param value The Kusto cluster display name.
     */
    @JvmName("junlxbojuocdowom")
    public suspend fun kustoClusterDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoClusterDisplayName = mapped
    }

    /**
     * @param value The Kusto cluster URI.
     */
    @JvmName("vhmvowtmuigdppsn")
    public suspend fun kustoClusterUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoClusterUri = mapped
    }

    /**
     * @param value The Kusto data ingestion URI.
     */
    @JvmName("htmfdxlwjqmomrdr")
    public suspend fun kustoDataIngestionUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoDataIngestionUri = mapped
    }

    /**
     * @param value The name of a Kusto database.
     */
    @JvmName("jouvkyvusdawewfv")
    public suspend fun kustoDatabaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoDatabaseName = mapped
    }

    /**
     * @param value The Kusto management URL.
     */
    @JvmName("tjmleyeoadgjsjbk")
    public suspend fun kustoManagementUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoManagementUrl = mapped
    }

    /**
     * @param value The type of a Kusto offering.
     */
    @JvmName("hahunamsggakpagb")
    public suspend fun kustoOfferingType(`value`: Either<String, KustoOfferingType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoOfferingType = mapped
    }

    /**
     * @param value The type of a Kusto offering.
     */
    @JvmName("apokmjcnxxyajgat")
    public fun kustoOfferingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KustoOfferingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoOfferingType = mapped
    }

    /**
     * @param value The type of a Kusto offering.
     */
    @JvmName("fwaudjhhcjksagld")
    public fun kustoOfferingType(`value`: KustoOfferingType) {
        val toBeMapped = Either.ofRight<String, KustoOfferingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustoOfferingType = mapped
    }

    internal fun build(): DatastoreArgs = DatastoreArgs(
        adxClusterResourceId = adxClusterResourceId,
        kustoClusterDisplayName = kustoClusterDisplayName,
        kustoClusterUri = kustoClusterUri ?: throw PulumiNullFieldException("kustoClusterUri"),
        kustoDataIngestionUri = kustoDataIngestionUri ?: throw
            PulumiNullFieldException("kustoDataIngestionUri"),
        kustoDatabaseName = kustoDatabaseName ?: throw PulumiNullFieldException("kustoDatabaseName"),
        kustoManagementUrl = kustoManagementUrl ?: throw PulumiNullFieldException("kustoManagementUrl"),
        kustoOfferingType = kustoOfferingType ?: throw PulumiNullFieldException("kustoOfferingType"),
    )
}
