@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.inputs

import com.pulumi.azurenative.databasewatcher.inputs.GetWatcherPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property watcherName The database watcher name.
 */
public data class GetWatcherPlainArgs(
    public val resourceGroupName: String,
    public val watcherName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databasewatcher.inputs.GetWatcherPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databasewatcher.inputs.GetWatcherPlainArgs =
        com.pulumi.azurenative.databasewatcher.inputs.GetWatcherPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .watcherName(watcherName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWatcherPlainArgs].
 */
@PulumiTagMarker
public class GetWatcherPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var watcherName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fvidglsubfguagft")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The database watcher name.
     */
    @JvmName("wwuqscuwtrqicxwf")
    public suspend fun watcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.watcherName = mapped
    }

    internal fun build(): GetWatcherPlainArgs = GetWatcherPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        watcherName = watcherName ?: throw PulumiNullFieldException("watcherName"),
    )
}
