@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a data store.
 * @property adxClusterResourceId The Azure ResourceId of an Azure Data Explorer cluster.
 * @property kustoClusterDisplayName The Kusto cluster display name.
 * @property kustoClusterUri The Kusto cluster URI.
 * @property kustoDataIngestionUri The Kusto data ingestion URI.
 * @property kustoDatabaseName The name of a Kusto database.
 * @property kustoManagementUrl The Kusto management URL.
 * @property kustoOfferingType The type of a Kusto offering.
 */
public data class DatastoreResponse(
    public val adxClusterResourceId: String? = null,
    public val kustoClusterDisplayName: String? = null,
    public val kustoClusterUri: String,
    public val kustoDataIngestionUri: String,
    public val kustoDatabaseName: String,
    public val kustoManagementUrl: String,
    public val kustoOfferingType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.outputs.DatastoreResponse):
            DatastoreResponse = DatastoreResponse(
            adxClusterResourceId = javaType.adxClusterResourceId().map({ args0 -> args0 }).orElse(null),
            kustoClusterDisplayName = javaType.kustoClusterDisplayName().map({ args0 -> args0 }).orElse(null),
            kustoClusterUri = javaType.kustoClusterUri(),
            kustoDataIngestionUri = javaType.kustoDataIngestionUri(),
            kustoDatabaseName = javaType.kustoDatabaseName(),
            kustoManagementUrl = javaType.kustoManagementUrl(),
            kustoOfferingType = javaType.kustoOfferingType(),
        )
    }
}
