@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * @property dnsZone The DNS zone to be included in the DNS name of the shared private link. Value is service-specific.
 * @property groupId The group id from the provider of resource the shared private link resource is for.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property privateLinkResourceId The resource id of the resource the shared private link resource is for.
 * @property provisioningState The provisioning state of the resource.
 * @property requestMessage The request message for requesting approval of the shared private link resource.
 * @property status Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSharedPrivateLinkResourceResult(
    public val dnsZone: String? = null,
    public val groupId: String,
    public val id: String,
    public val name: String,
    public val privateLinkResourceId: String,
    public val provisioningState: String,
    public val requestMessage: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databasewatcher.outputs.GetSharedPrivateLinkResourceResult):
            GetSharedPrivateLinkResourceResult = GetSharedPrivateLinkResourceResult(
            dnsZone = javaType.dnsZone().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId(),
            id = javaType.id(),
            name = javaType.name(),
            privateLinkResourceId = javaType.privateLinkResourceId(),
            provisioningState = javaType.provisioningState(),
            requestMessage = javaType.requestMessage(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
