@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of encryption key used for key encryption.
 */
public enum class KekType(
    public val javaValue: com.pulumi.azurenative.databox.enums.KekType,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.KekType> {
    /**
     * Key encryption key is managed by Microsoft.
     */
    MicrosoftManaged(com.pulumi.azurenative.databox.enums.KekType.MicrosoftManaged),

    /**
     * Key encryption key is managed by the Customer.
     */
    CustomerManaged(com.pulumi.azurenative.databox.enums.KekType.CustomerManaged),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.KekType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.KekType): KekType =
            KekType.values().first { it.javaValue == javaType }
    }
}
