@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Level of the logs to be collected.
 */
public enum class LogCollectionLevel(
    public val javaValue: com.pulumi.azurenative.databox.enums.LogCollectionLevel,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.LogCollectionLevel> {
    /**
     * Only Errors will be collected in the logs.
     */
    Error(com.pulumi.azurenative.databox.enums.LogCollectionLevel.Error),

    /**
     * Verbose logging (includes Errors, CRC, size information and others).
     */
    Verbose(com.pulumi.azurenative.databox.enums.LogCollectionLevel.Verbose),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.LogCollectionLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.LogCollectionLevel):
            LogCollectionLevel = LogCollectionLevel.values().first { it.javaValue == javaType }
    }
}
