@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The sku name.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.databox.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.databox.enums.SkuName> {
    /**
     * Data Box.
     */
    DataBox(com.pulumi.azurenative.databox.enums.SkuName.DataBox),

    /**
     * Data Box Disk.
     */
    DataBoxDisk(com.pulumi.azurenative.databox.enums.SkuName.DataBoxDisk),

    /**
     * Data Box Heavy.
     */
    DataBoxHeavy(com.pulumi.azurenative.databox.enums.SkuName.DataBoxHeavy),

    /**
     * Data Box Customer Disk.
     */
    DataBoxCustomerDisk(com.pulumi.azurenative.databox.enums.SkuName.DataBoxCustomerDisk),
    ;

    override fun toJava(): com.pulumi.azurenative.databox.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
