@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ContactDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contact Details.
 * @property contactName Contact name of the person.
 * @property emailList List of Email-ids to be notified about job progress.
 * @property mobile Mobile number of the contact person.
 * @property notificationPreference Notification preference for a job stage.
 * @property phone Phone number of the contact person.
 * @property phoneExtension Phone extension number of the contact person.
 */
public data class ContactDetailsArgs(
    public val contactName: Output<String>,
    public val emailList: Output<List<String>>,
    public val mobile: Output<String>? = null,
    public val notificationPreference: Output<List<NotificationPreferenceArgs>>? = null,
    public val phone: Output<String>,
    public val phoneExtension: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ContactDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ContactDetailsArgs =
        com.pulumi.azurenative.databox.inputs.ContactDetailsArgs.builder()
            .contactName(contactName.applyValue({ args0 -> args0 }))
            .emailList(emailList.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mobile(mobile?.applyValue({ args0 -> args0 }))
            .notificationPreference(
                notificationPreference?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .phone(phone.applyValue({ args0 -> args0 }))
            .phoneExtension(phoneExtension?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactDetailsArgs].
 */
@PulumiTagMarker
public class ContactDetailsArgsBuilder internal constructor() {
    private var contactName: Output<String>? = null

    private var emailList: Output<List<String>>? = null

    private var mobile: Output<String>? = null

    private var notificationPreference: Output<List<NotificationPreferenceArgs>>? = null

    private var phone: Output<String>? = null

    private var phoneExtension: Output<String>? = null

    /**
     * @param value Contact name of the person.
     */
    @JvmName("prfdajbwljnoqgpw")
    public suspend fun contactName(`value`: Output<String>) {
        this.contactName = value
    }

    /**
     * @param value List of Email-ids to be notified about job progress.
     */
    @JvmName("xkocyjhjmfbdyhiv")
    public suspend fun emailList(`value`: Output<List<String>>) {
        this.emailList = value
    }

    @JvmName("pnxjpbtqniivagva")
    public suspend fun emailList(vararg values: Output<String>) {
        this.emailList = Output.all(values.asList())
    }

    /**
     * @param values List of Email-ids to be notified about job progress.
     */
    @JvmName("sxhnimbwdfcrxrfk")
    public suspend fun emailList(values: List<Output<String>>) {
        this.emailList = Output.all(values)
    }

    /**
     * @param value Mobile number of the contact person.
     */
    @JvmName("jmhmawviojmelerg")
    public suspend fun mobile(`value`: Output<String>) {
        this.mobile = value
    }

    /**
     * @param value Notification preference for a job stage.
     */
    @JvmName("buicatcefmywojdd")
    public suspend fun notificationPreference(`value`: Output<List<NotificationPreferenceArgs>>) {
        this.notificationPreference = value
    }

    @JvmName("apridugtdbpuxwpi")
    public suspend fun notificationPreference(vararg values: Output<NotificationPreferenceArgs>) {
        this.notificationPreference = Output.all(values.asList())
    }

    /**
     * @param values Notification preference for a job stage.
     */
    @JvmName("gauaqdadvnbygmkr")
    public suspend fun notificationPreference(values: List<Output<NotificationPreferenceArgs>>) {
        this.notificationPreference = Output.all(values)
    }

    /**
     * @param value Phone number of the contact person.
     */
    @JvmName("skwdqmhuvujmnsye")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Phone extension number of the contact person.
     */
    @JvmName("pgsoyaeoyjafqrpw")
    public suspend fun phoneExtension(`value`: Output<String>) {
        this.phoneExtension = value
    }

    /**
     * @param value Contact name of the person.
     */
    @JvmName("dosdphqkbepnaxvw")
    public suspend fun contactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactName = mapped
    }

    /**
     * @param value List of Email-ids to be notified about job progress.
     */
    @JvmName("olvpyfgvujpsmsgd")
    public suspend fun emailList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailList = mapped
    }

    /**
     * @param values List of Email-ids to be notified about job progress.
     */
    @JvmName("ipocyivldolenvij")
    public suspend fun emailList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailList = mapped
    }

    /**
     * @param value Mobile number of the contact person.
     */
    @JvmName("kpgliwyepuhfaqtb")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobile = mapped
    }

    /**
     * @param value Notification preference for a job stage.
     */
    @JvmName("wbuicpcsvvtagdfp")
    public suspend fun notificationPreference(`value`: List<NotificationPreferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationPreference = mapped
    }

    /**
     * @param argument Notification preference for a job stage.
     */
    @JvmName("sxfylwpbcoudopqa")
    public suspend
    fun notificationPreference(argument: List<suspend NotificationPreferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NotificationPreferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationPreference = mapped
    }

    /**
     * @param argument Notification preference for a job stage.
     */
    @JvmName("psxtovxdnatvovpe")
    public suspend fun notificationPreference(
        vararg
        argument: suspend NotificationPreferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NotificationPreferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationPreference = mapped
    }

    /**
     * @param argument Notification preference for a job stage.
     */
    @JvmName("wfjtjxloktmjebol")
    public suspend
    fun notificationPreference(argument: suspend NotificationPreferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NotificationPreferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notificationPreference = mapped
    }

    /**
     * @param values Notification preference for a job stage.
     */
    @JvmName("enkbotssdrwoekol")
    public suspend fun notificationPreference(vararg values: NotificationPreferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationPreference = mapped
    }

    /**
     * @param value Phone number of the contact person.
     */
    @JvmName("sddidyogsolsfmrr")
    public suspend fun phone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value Phone extension number of the contact person.
     */
    @JvmName("amdlwcjobijxcaxr")
    public suspend fun phoneExtension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneExtension = mapped
    }

    internal fun build(): ContactDetailsArgs = ContactDetailsArgs(
        contactName = contactName ?: throw PulumiNullFieldException("contactName"),
        emailList = emailList ?: throw PulumiNullFieldException("emailList"),
        mobile = mobile,
        notificationPreference = notificationPreference,
        phone = phone ?: throw PulumiNullFieldException("phone"),
        phoneExtension = phoneExtension,
    )
}
