@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.DataBoxJobDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Databox Job Details
 * @property contactDetails Contact details for notification and shipping.
 * @property dataExportDetails Details of the data to be exported from azure.
 * @property dataImportDetails Details of the data to be imported into azure.
 * @property devicePassword Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
 * @property expectedDataSizeInTeraBytes The expected size of the data, which needs to be transferred in this job, in terabytes.
 * @property jobDetailsType Indicates the type of job details.
 * Expected value is 'DataBox'.
 * @property keyEncryptionKey Details about which key encryption type is being used.
 * @property preferences Preferences for the order.
 * @property reverseShippingDetails Optional Reverse Shipping details for order.
 * @property shippingAddress Shipping address of the customer.
 */
public data class DataBoxJobDetailsArgs(
    public val contactDetails: Output<ContactDetailsArgs>,
    public val dataExportDetails: Output<List<DataExportDetailsArgs>>? = null,
    public val dataImportDetails: Output<List<DataImportDetailsArgs>>? = null,
    public val devicePassword: Output<String>? = null,
    public val expectedDataSizeInTeraBytes: Output<Int>? = null,
    public val jobDetailsType: Output<String>,
    public val keyEncryptionKey: Output<KeyEncryptionKeyArgs>? = null,
    public val preferences: Output<PreferencesArgs>? = null,
    public val reverseShippingDetails: Output<ReverseShippingDetailsArgs>? = null,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.DataBoxJobDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.DataBoxJobDetailsArgs =
        com.pulumi.azurenative.databox.inputs.DataBoxJobDetailsArgs.builder()
            .contactDetails(contactDetails.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataExportDetails(
                dataExportDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataImportDetails(
                dataImportDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .devicePassword(devicePassword?.applyValue({ args0 -> args0 }))
            .expectedDataSizeInTeraBytes(expectedDataSizeInTeraBytes?.applyValue({ args0 -> args0 }))
            .jobDetailsType(jobDetailsType.applyValue({ args0 -> args0 }))
            .keyEncryptionKey(keyEncryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preferences(preferences?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reverseShippingDetails(
                reverseShippingDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataBoxJobDetailsArgs].
 */
@PulumiTagMarker
public class DataBoxJobDetailsArgsBuilder internal constructor() {
    private var contactDetails: Output<ContactDetailsArgs>? = null

    private var dataExportDetails: Output<List<DataExportDetailsArgs>>? = null

    private var dataImportDetails: Output<List<DataImportDetailsArgs>>? = null

    private var devicePassword: Output<String>? = null

    private var expectedDataSizeInTeraBytes: Output<Int>? = null

    private var jobDetailsType: Output<String>? = null

    private var keyEncryptionKey: Output<KeyEncryptionKeyArgs>? = null

    private var preferences: Output<PreferencesArgs>? = null

    private var reverseShippingDetails: Output<ReverseShippingDetailsArgs>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    /**
     * @param value Contact details for notification and shipping.
     */
    @JvmName("llxfvjmyfiuujfdy")
    public suspend fun contactDetails(`value`: Output<ContactDetailsArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value Details of the data to be exported from azure.
     */
    @JvmName("wjhimujcbyjjyqfi")
    public suspend fun dataExportDetails(`value`: Output<List<DataExportDetailsArgs>>) {
        this.dataExportDetails = value
    }

    @JvmName("etxuxnehnxqmqqio")
    public suspend fun dataExportDetails(vararg values: Output<DataExportDetailsArgs>) {
        this.dataExportDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the data to be exported from azure.
     */
    @JvmName("ccjpuubqrxgfyxyk")
    public suspend fun dataExportDetails(values: List<Output<DataExportDetailsArgs>>) {
        this.dataExportDetails = Output.all(values)
    }

    /**
     * @param value Details of the data to be imported into azure.
     */
    @JvmName("rfeualjywqyqugnv")
    public suspend fun dataImportDetails(`value`: Output<List<DataImportDetailsArgs>>) {
        this.dataImportDetails = value
    }

    @JvmName("tmbvcxkpqjcstdct")
    public suspend fun dataImportDetails(vararg values: Output<DataImportDetailsArgs>) {
        this.dataImportDetails = Output.all(values.asList())
    }

    /**
     * @param values Details of the data to be imported into azure.
     */
    @JvmName("rsyqqmbudfkmnpng")
    public suspend fun dataImportDetails(values: List<Output<DataImportDetailsArgs>>) {
        this.dataImportDetails = Output.all(values)
    }

    /**
     * @param value Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
     */
    @JvmName("ammlqklanyymipcd")
    public suspend fun devicePassword(`value`: Output<String>) {
        this.devicePassword = value
    }

    /**
     * @param value The expected size of the data, which needs to be transferred in this job, in terabytes.
     */
    @JvmName("yipxlvcioufdmkey")
    public suspend fun expectedDataSizeInTeraBytes(`value`: Output<Int>) {
        this.expectedDataSizeInTeraBytes = value
    }

    /**
     * @param value Indicates the type of job details.
     * Expected value is 'DataBox'.
     */
    @JvmName("uqpfsfvnumpijddw")
    public suspend fun jobDetailsType(`value`: Output<String>) {
        this.jobDetailsType = value
    }

    /**
     * @param value Details about which key encryption type is being used.
     */
    @JvmName("dvniytosclfwopom")
    public suspend fun keyEncryptionKey(`value`: Output<KeyEncryptionKeyArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value Preferences for the order.
     */
    @JvmName("jafdrmbtgltvxukx")
    public suspend fun preferences(`value`: Output<PreferencesArgs>) {
        this.preferences = value
    }

    /**
     * @param value Optional Reverse Shipping details for order.
     */
    @JvmName("thpeqhgsdgkjhrrg")
    public suspend fun reverseShippingDetails(`value`: Output<ReverseShippingDetailsArgs>) {
        this.reverseShippingDetails = value
    }

    /**
     * @param value Shipping address of the customer.
     */
    @JvmName("smobdashysnegyqv")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Contact details for notification and shipping.
     */
    @JvmName("mfukslbqtrgtaybv")
    public suspend fun contactDetails(`value`: ContactDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact details for notification and shipping.
     */
    @JvmName("nuiqextltiyuajmx")
    public suspend fun contactDetails(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value Details of the data to be exported from azure.
     */
    @JvmName("cdumloalnxusyfof")
    public suspend fun dataExportDetails(`value`: List<DataExportDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("mngtsurcqimclqsi")
    public suspend
    fun dataExportDetails(argument: List<suspend DataExportDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataExportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("vuyjbhidxqsmkuja")
    public suspend fun dataExportDetails(
        vararg
        argument: suspend DataExportDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataExportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param argument Details of the data to be exported from azure.
     */
    @JvmName("mysxgfltijlquhlb")
    public suspend fun dataExportDetails(argument: suspend DataExportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataExportDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataExportDetails = mapped
    }

    /**
     * @param values Details of the data to be exported from azure.
     */
    @JvmName("atacgonntiadpcef")
    public suspend fun dataExportDetails(vararg values: DataExportDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataExportDetails = mapped
    }

    /**
     * @param value Details of the data to be imported into azure.
     */
    @JvmName("bmjfqdsfffictnfo")
    public suspend fun dataImportDetails(`value`: List<DataImportDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("iokqlqcybhuuxqpc")
    public suspend
    fun dataImportDetails(argument: List<suspend DataImportDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataImportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("dorytgbcsuelaweb")
    public suspend fun dataImportDetails(
        vararg
        argument: suspend DataImportDetailsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataImportDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param argument Details of the data to be imported into azure.
     */
    @JvmName("xcopcilugptcnkxa")
    public suspend fun dataImportDetails(argument: suspend DataImportDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataImportDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataImportDetails = mapped
    }

    /**
     * @param values Details of the data to be imported into azure.
     */
    @JvmName("oqyqnvficuprnqyo")
    public suspend fun dataImportDetails(vararg values: DataImportDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataImportDetails = mapped
    }

    /**
     * @param value Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
     */
    @JvmName("vkialiehepcyjitj")
    public suspend fun devicePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devicePassword = mapped
    }

    /**
     * @param value The expected size of the data, which needs to be transferred in this job, in terabytes.
     */
    @JvmName("uythctcgngufxumh")
    public suspend fun expectedDataSizeInTeraBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedDataSizeInTeraBytes = mapped
    }

    /**
     * @param value Indicates the type of job details.
     * Expected value is 'DataBox'.
     */
    @JvmName("auflslhbgfsxdmug")
    public suspend fun jobDetailsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobDetailsType = mapped
    }

    /**
     * @param value Details about which key encryption type is being used.
     */
    @JvmName("ffowlfqlgjgnpvbw")
    public suspend fun keyEncryptionKey(`value`: KeyEncryptionKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Details about which key encryption type is being used.
     */
    @JvmName("avkftrtwqtvcvqcf")
    public suspend fun keyEncryptionKey(argument: suspend KeyEncryptionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyEncryptionKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    /**
     * @param value Preferences for the order.
     */
    @JvmName("dfvwddwuikvxyhjd")
    public suspend fun preferences(`value`: PreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferences = mapped
    }

    /**
     * @param argument Preferences for the order.
     */
    @JvmName("xanvkllfllmlwicf")
    public suspend fun preferences(argument: suspend PreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = PreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preferences = mapped
    }

    /**
     * @param value Optional Reverse Shipping details for order.
     */
    @JvmName("umlgehjbqrmnbyaw")
    public suspend fun reverseShippingDetails(`value`: ReverseShippingDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reverseShippingDetails = mapped
    }

    /**
     * @param argument Optional Reverse Shipping details for order.
     */
    @JvmName("crrpnhqqdhrqjcbu")
    public suspend
    fun reverseShippingDetails(argument: suspend ReverseShippingDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ReverseShippingDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reverseShippingDetails = mapped
    }

    /**
     * @param value Shipping address of the customer.
     */
    @JvmName("bdmnoeqfhqtjmebv")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping address of the customer.
     */
    @JvmName("lqmenxbehcitxnxh")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): DataBoxJobDetailsArgs = DataBoxJobDetailsArgs(
        contactDetails = contactDetails ?: throw PulumiNullFieldException("contactDetails"),
        dataExportDetails = dataExportDetails,
        dataImportDetails = dataImportDetails,
        devicePassword = devicePassword,
        expectedDataSizeInTeraBytes = expectedDataSizeInTeraBytes,
        jobDetailsType = jobDetailsType ?: throw PulumiNullFieldException("jobDetailsType"),
        keyEncryptionKey = keyEncryptionKey,
        preferences = preferences,
        reverseShippingDetails = reverseShippingDetails,
        shippingAddress = shippingAddress,
    )
}
