@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.DataExportDetailsArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.LogCollectionLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of the data to be used for exporting data from azure.
 * @property accountDetails Account details of the data to be transferred
 * @property logCollectionLevel Level of the logs to be collected.
 * @property transferConfiguration Configuration for the data transfer.
 */
public data class DataExportDetailsArgs(
    public val accountDetails: Output<Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>>,
    public val logCollectionLevel: Output<Either<String, LogCollectionLevel>>? = null,
    public val transferConfiguration: Output<TransferConfigurationArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.DataExportDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.DataExportDetailsArgs =
        com.pulumi.azurenative.databox.inputs.DataExportDetailsArgs.builder()
            .accountDetails(
                accountDetails.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .logCollectionLevel(
                logCollectionLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .transferConfiguration(
                transferConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataExportDetailsArgs].
 */
@PulumiTagMarker
public class DataExportDetailsArgsBuilder internal constructor() {
    private var accountDetails: Output<Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>>? =
        null

    private var logCollectionLevel: Output<Either<String, LogCollectionLevel>>? = null

    private var transferConfiguration: Output<TransferConfigurationArgs>? = null

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("sdyacdfnlewylfms")
    public suspend
    fun accountDetails(`value`: Output<Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>>) {
        this.accountDetails = value
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("prxuxmdvmbqysjil")
    public suspend fun logCollectionLevel(`value`: Output<Either<String, LogCollectionLevel>>) {
        this.logCollectionLevel = value
    }

    /**
     * @param value Configuration for the data transfer.
     */
    @JvmName("hoghjaaofnbwdftv")
    public suspend fun transferConfiguration(`value`: Output<TransferConfigurationArgs>) {
        this.transferConfiguration = value
    }

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("ttlxieabmcxqirlw")
    public suspend
    fun accountDetails(`value`: Either<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountDetails = mapped
    }

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("njskhwrsibtknvoo")
    public fun accountDetails(`value`: ManagedDiskDetailsArgs) {
        val toBeMapped = Either.ofLeft<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountDetails = mapped
    }

    /**
     * @param value Account details of the data to be transferred
     */
    @JvmName("ygiwhesykkrbhgpe")
    public fun accountDetails(`value`: StorageAccountDetailsArgs) {
        val toBeMapped = Either.ofRight<ManagedDiskDetailsArgs, StorageAccountDetailsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountDetails = mapped
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("htttyklfvukdxwvx")
    public suspend fun logCollectionLevel(`value`: Either<String, LogCollectionLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logCollectionLevel = mapped
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("pxkqvipdbptusiig")
    public fun logCollectionLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogCollectionLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logCollectionLevel = mapped
    }

    /**
     * @param value Level of the logs to be collected.
     */
    @JvmName("rtmvyxuiudxksfgt")
    public fun logCollectionLevel(`value`: LogCollectionLevel) {
        val toBeMapped = Either.ofRight<String, LogCollectionLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logCollectionLevel = mapped
    }

    /**
     * @param value Configuration for the data transfer.
     */
    @JvmName("viyyhfrthxbnqcdo")
    public suspend fun transferConfiguration(`value`: TransferConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transferConfiguration = mapped
    }

    /**
     * @param argument Configuration for the data transfer.
     */
    @JvmName("qadajxioospkbapc")
    public suspend
    fun transferConfiguration(argument: suspend TransferConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TransferConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transferConfiguration = mapped
    }

    internal fun build(): DataExportDetailsArgs = DataExportDetailsArgs(
        accountDetails = accountDetails ?: throw PulumiNullFieldException("accountDetails"),
        logCollectionLevel = logCollectionLevel,
        transferConfiguration = transferConfiguration ?: throw
            PulumiNullFieldException("transferConfiguration"),
    )
}
