@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.JobDeliveryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional delivery info.
 * @property scheduledDateTime Scheduled date time.
 */
public data class JobDeliveryInfoArgs(
    public val scheduledDateTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.JobDeliveryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.JobDeliveryInfoArgs =
        com.pulumi.azurenative.databox.inputs.JobDeliveryInfoArgs.builder()
            .scheduledDateTime(scheduledDateTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDeliveryInfoArgs].
 */
@PulumiTagMarker
public class JobDeliveryInfoArgsBuilder internal constructor() {
    private var scheduledDateTime: Output<String>? = null

    /**
     * @param value Scheduled date time.
     */
    @JvmName("jkaavpgfcefynjvx")
    public suspend fun scheduledDateTime(`value`: Output<String>) {
        this.scheduledDateTime = value
    }

    /**
     * @param value Scheduled date time.
     */
    @JvmName("ouxojffbnedgexnr")
    public suspend fun scheduledDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledDateTime = mapped
    }

    internal fun build(): JobDeliveryInfoArgs = JobDeliveryInfoArgs(
        scheduledDateTime = scheduledDateTime,
    )
}
