@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.inputs

import com.pulumi.azurenative.databox.inputs.ShippingAddressArgs.builder
import com.pulumi.azurenative.databox.kotlin.enums.AddressType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Shipping address where customer wishes to receive the device.
 * @property addressType Type of address.
 * @property city Name of the City.
 * @property companyName Name of the company.
 * @property country Name of the Country.
 * @property postalCode Postal code.
 * @property skipAddressValidation Flag to indicate if customer has chosen to skip default address validation
 * @property stateOrProvince Name of the State or Province.
 * @property streetAddress1 Street Address line 1.
 * @property streetAddress2 Street Address line 2.
 * @property streetAddress3 Street Address line 3.
 * @property taxIdentificationNumber Tax Identification Number
 * @property zipExtendedCode Extended Zip Code.
 */
public data class ShippingAddressArgs(
    public val addressType: Output<Either<String, AddressType>>? = null,
    public val city: Output<String>? = null,
    public val companyName: Output<String>? = null,
    public val country: Output<String>,
    public val postalCode: Output<String>? = null,
    public val skipAddressValidation: Output<Boolean>? = null,
    public val stateOrProvince: Output<String>? = null,
    public val streetAddress1: Output<String>,
    public val streetAddress2: Output<String>? = null,
    public val streetAddress3: Output<String>? = null,
    public val taxIdentificationNumber: Output<String>? = null,
    public val zipExtendedCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databox.inputs.ShippingAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.databox.inputs.ShippingAddressArgs =
        com.pulumi.azurenative.databox.inputs.ShippingAddressArgs.builder()
            .addressType(
                addressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .city(city?.applyValue({ args0 -> args0 }))
            .companyName(companyName?.applyValue({ args0 -> args0 }))
            .country(country.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .skipAddressValidation(skipAddressValidation?.applyValue({ args0 -> args0 }))
            .stateOrProvince(stateOrProvince?.applyValue({ args0 -> args0 }))
            .streetAddress1(streetAddress1.applyValue({ args0 -> args0 }))
            .streetAddress2(streetAddress2?.applyValue({ args0 -> args0 }))
            .streetAddress3(streetAddress3?.applyValue({ args0 -> args0 }))
            .taxIdentificationNumber(taxIdentificationNumber?.applyValue({ args0 -> args0 }))
            .zipExtendedCode(zipExtendedCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShippingAddressArgs].
 */
@PulumiTagMarker
public class ShippingAddressArgsBuilder internal constructor() {
    private var addressType: Output<Either<String, AddressType>>? = null

    private var city: Output<String>? = null

    private var companyName: Output<String>? = null

    private var country: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var skipAddressValidation: Output<Boolean>? = null

    private var stateOrProvince: Output<String>? = null

    private var streetAddress1: Output<String>? = null

    private var streetAddress2: Output<String>? = null

    private var streetAddress3: Output<String>? = null

    private var taxIdentificationNumber: Output<String>? = null

    private var zipExtendedCode: Output<String>? = null

    /**
     * @param value Type of address.
     */
    @JvmName("oypxwyvsobgjqsds")
    public suspend fun addressType(`value`: Output<Either<String, AddressType>>) {
        this.addressType = value
    }

    /**
     * @param value Name of the City.
     */
    @JvmName("eebafwfoxmfnacaw")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value Name of the company.
     */
    @JvmName("cjdxmxurkqqdqlcu")
    public suspend fun companyName(`value`: Output<String>) {
        this.companyName = value
    }

    /**
     * @param value Name of the Country.
     */
    @JvmName("ohvghruiunyjwffq")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value Postal code.
     */
    @JvmName("itwdawfcvwnyepdc")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value Flag to indicate if customer has chosen to skip default address validation
     */
    @JvmName("eejleuudbsujpjit")
    public suspend fun skipAddressValidation(`value`: Output<Boolean>) {
        this.skipAddressValidation = value
    }

    /**
     * @param value Name of the State or Province.
     */
    @JvmName("ynkqgeqakkjibvkg")
    public suspend fun stateOrProvince(`value`: Output<String>) {
        this.stateOrProvince = value
    }

    /**
     * @param value Street Address line 1.
     */
    @JvmName("musybvdgceteeupc")
    public suspend fun streetAddress1(`value`: Output<String>) {
        this.streetAddress1 = value
    }

    /**
     * @param value Street Address line 2.
     */
    @JvmName("ltnhejuvwkqnwqsn")
    public suspend fun streetAddress2(`value`: Output<String>) {
        this.streetAddress2 = value
    }

    /**
     * @param value Street Address line 3.
     */
    @JvmName("uvshdbqcbymeaoqf")
    public suspend fun streetAddress3(`value`: Output<String>) {
        this.streetAddress3 = value
    }

    /**
     * @param value Tax Identification Number
     */
    @JvmName("myxitpjgvplsklpw")
    public suspend fun taxIdentificationNumber(`value`: Output<String>) {
        this.taxIdentificationNumber = value
    }

    /**
     * @param value Extended Zip Code.
     */
    @JvmName("etikprcghaqltpcg")
    public suspend fun zipExtendedCode(`value`: Output<String>) {
        this.zipExtendedCode = value
    }

    /**
     * @param value Type of address.
     */
    @JvmName("xkckfwognbwxjust")
    public suspend fun addressType(`value`: Either<String, AddressType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Type of address.
     */
    @JvmName("uggepbifqodcojwq")
    public fun addressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Type of address.
     */
    @JvmName("moigubfoqfmngwam")
    public fun addressType(`value`: AddressType) {
        val toBeMapped = Either.ofRight<String, AddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Name of the City.
     */
    @JvmName("badtdvwafmqcomum")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value Name of the company.
     */
    @JvmName("kcnxoevybtnywibq")
    public suspend fun companyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyName = mapped
    }

    /**
     * @param value Name of the Country.
     */
    @JvmName("ktogardqcxblwevy")
    public suspend fun country(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value Postal code.
     */
    @JvmName("coappuuflbdytleh")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value Flag to indicate if customer has chosen to skip default address validation
     */
    @JvmName("mggycvdjpfysguqb")
    public suspend fun skipAddressValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipAddressValidation = mapped
    }

    /**
     * @param value Name of the State or Province.
     */
    @JvmName("edtlishuwatmbqpt")
    public suspend fun stateOrProvince(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stateOrProvince = mapped
    }

    /**
     * @param value Street Address line 1.
     */
    @JvmName("imuurwqtuhflpmam")
    public suspend fun streetAddress1(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streetAddress1 = mapped
    }

    /**
     * @param value Street Address line 2.
     */
    @JvmName("bxrhipllafqfwmre")
    public suspend fun streetAddress2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress2 = mapped
    }

    /**
     * @param value Street Address line 3.
     */
    @JvmName("jfywtwxylphmwams")
    public suspend fun streetAddress3(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress3 = mapped
    }

    /**
     * @param value Tax Identification Number
     */
    @JvmName("wfrbyrjfngcugeuh")
    public suspend fun taxIdentificationNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taxIdentificationNumber = mapped
    }

    /**
     * @param value Extended Zip Code.
     */
    @JvmName("btyxflywyqmsgjcc")
    public suspend fun zipExtendedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipExtendedCode = mapped
    }

    internal fun build(): ShippingAddressArgs = ShippingAddressArgs(
        addressType = addressType,
        city = city,
        companyName = companyName,
        country = country ?: throw PulumiNullFieldException("country"),
        postalCode = postalCode,
        skipAddressValidation = skipAddressValidation,
        stateOrProvince = stateOrProvince,
        streetAddress1 = streetAddress1 ?: throw PulumiNullFieldException("streetAddress1"),
        streetAddress2 = streetAddress2,
        streetAddress3 = streetAddress3,
        taxIdentificationNumber = taxIdentificationNumber,
        zipExtendedCode = zipExtendedCode,
    )
}
