@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filter details to transfer Azure Blobs
 * @property blobPathList List of full path of the blobs to be transferred.
 * @property blobPrefixList Prefix list of the Azure blobs to be transferred.
 * @property containerList List of blob containers to be transferred.
 */
public data class BlobFilterDetailsResponse(
    public val blobPathList: List<String>? = null,
    public val blobPrefixList: List<String>? = null,
    public val containerList: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.BlobFilterDetailsResponse):
            BlobFilterDetailsResponse = BlobFilterDetailsResponse(
            blobPathList = javaType.blobPathList().map({ args0 -> args0 }),
            blobPrefixList = javaType.blobPrefixList().map({ args0 -> args0 }),
            containerList = javaType.containerList().map({ args0 -> args0 }),
        )
    }
}
