@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Customer disk job details.
 * @property actions Available actions on the job.
 * @property chainOfCustodySasKey Shared access key to download the chain of custody logs
 * @property contactDetails Contact details for notification and shipping.
 * @property copyLogDetails List of copy log details.
 * @property copyProgress Copy progress per disk.
 * @property dataCenterCode DataCenter code.
 * @property dataExportDetails Details of the data to be exported from azure.
 * @property dataImportDetails Details of the data to be imported into azure.
 * @property datacenterAddress Datacenter address to ship to, for the given sku and storage location.
 * @property deliverToDcPackageDetails Delivery package shipping details.
 * @property deliveryPackage Delivery package shipping details.
 * @property deviceErasureDetails Holds device data erasure details
 * @property enableManifestBackup Flag to indicate if disk manifest should be backed-up in the Storage Account.
 * @property expectedDataSizeInTeraBytes The expected size of the data, which needs to be transferred in this job, in terabytes.
 * @property exportDiskDetailsCollection Contains the map of disk serial number to the disk details for export jobs.
 * @property importDiskDetailsCollection Contains the map of disk serial number to the disk details for import jobs.
 * @property jobDetailsType Indicates the type of job details.
 * Expected value is 'DataBoxCustomerDisk'.
 * @property jobStages List of stages that run in the job.
 * @property keyEncryptionKey Details about which key encryption type is being used.
 * @property lastMitigationActionOnJob Last mitigation action performed on the job.
 * @property preferences Preferences for the order.
 * @property returnPackage Return package shipping details.
 * @property returnToCustomerPackageDetails Return package shipping details.
 * @property reverseShipmentLabelSasKey Shared access key to download the return shipment label
 * @property reverseShippingDetails Optional Reverse Shipping details for order.
 * @property shippingAddress Shipping address of the customer.
 */
public data class DataBoxCustomerDiskJobDetailsResponse(
    public val actions: List<String>,
    public val chainOfCustodySasKey: String,
    public val contactDetails: ContactDetailsResponse,
    public val copyLogDetails: List<Any>,
    public val copyProgress: List<DataBoxCustomerDiskCopyProgressResponse>,
    public val dataCenterCode: String,
    public val dataExportDetails: List<DataExportDetailsResponse>? = null,
    public val dataImportDetails: List<DataImportDetailsResponse>? = null,
    public val datacenterAddress:
    Either<DatacenterAddressInstructionResponseResponse, DatacenterAddressLocationResponseResponse>,
    public val deliverToDcPackageDetails: PackageCarrierInfoResponse,
    public val deliveryPackage: PackageShippingDetailsResponse,
    public val deviceErasureDetails: DeviceErasureDetailsResponse,
    public val enableManifestBackup: Boolean? = null,
    public val expectedDataSizeInTeraBytes: Int? = null,
    public val exportDiskDetailsCollection: Map<String, ExportDiskDetailsResponse>,
    public val importDiskDetailsCollection: Map<String, ImportDiskDetailsResponse>? = null,
    public val jobDetailsType: String,
    public val jobStages: List<JobStagesResponse>,
    public val keyEncryptionKey: KeyEncryptionKeyResponse? = null,
    public val lastMitigationActionOnJob: LastMitigationActionOnJobResponse,
    public val preferences: PreferencesResponse? = null,
    public val returnPackage: PackageShippingDetailsResponse,
    public val returnToCustomerPackageDetails: PackageCarrierDetailsResponse,
    public val reverseShipmentLabelSasKey: String,
    public val reverseShippingDetails: ReverseShippingDetailsResponse? = null,
    public val shippingAddress: ShippingAddressResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxCustomerDiskJobDetailsResponse):
            DataBoxCustomerDiskJobDetailsResponse = DataBoxCustomerDiskJobDetailsResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            chainOfCustodySasKey = javaType.chainOfCustodySasKey(),
            contactDetails = javaType.contactDetails().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin(args0)
            }),
            copyLogDetails = javaType.copyLogDetails().map({ args0 -> args0 }),
            copyProgress = javaType.copyProgress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataBoxCustomerDiskCopyProgressResponse.Companion.toKotlin(args0)
                })
            }),
            dataCenterCode = javaType.dataCenterCode(),
            dataExportDetails = javaType.dataExportDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataExportDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            dataImportDetails = javaType.dataImportDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.DataImportDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            datacenterAddress = javaType.datacenterAddress().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.DatacenterAddressInstructionResponseResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.DatacenterAddressLocationResponseResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            deliverToDcPackageDetails = javaType.deliverToDcPackageDetails().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.PackageCarrierInfoResponse.Companion.toKotlin(args0)
            }),
            deliveryPackage = javaType.deliveryPackage().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.PackageShippingDetailsResponse.Companion.toKotlin(args0)
            }),
            deviceErasureDetails = javaType.deviceErasureDetails().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.DeviceErasureDetailsResponse.Companion.toKotlin(args0)
            }),
            enableManifestBackup = javaType.enableManifestBackup().map({ args0 -> args0 }).orElse(null),
            expectedDataSizeInTeraBytes = javaType.expectedDataSizeInTeraBytes().map({ args0 ->
                args0
            }).orElse(null),
            exportDiskDetailsCollection = javaType.exportDiskDetailsCollection().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.ExportDiskDetailsResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            importDiskDetailsCollection = javaType.importDiskDetailsCollection().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.ImportDiskDetailsResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            jobDetailsType = javaType.jobDetailsType(),
            jobStages = javaType.jobStages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.JobStagesResponse.Companion.toKotlin(args0)
                })
            }),
            keyEncryptionKey = javaType.keyEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.KeyEncryptionKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastMitigationActionOnJob = javaType.lastMitigationActionOnJob().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.LastMitigationActionOnJobResponse.Companion.toKotlin(args0)
            }),
            preferences = javaType.preferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.PreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            returnPackage = javaType.returnPackage().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.PackageShippingDetailsResponse.Companion.toKotlin(args0)
            }),
            returnToCustomerPackageDetails = javaType.returnToCustomerPackageDetails().let({ args0 ->
                com.pulumi.azurenative.databox.kotlin.outputs.PackageCarrierDetailsResponse.Companion.toKotlin(args0)
            }),
            reverseShipmentLabelSasKey = javaType.reverseShipmentLabelSasKey(),
            reverseShippingDetails = javaType.reverseShippingDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ReverseShippingDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            shippingAddress = javaType.shippingAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
