@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The secrets related to a databox heavy.
 * @property accountCredentialDetails Per account level access credentials.
 * @property devicePassword Password for out of the box experience on device.
 * @property deviceSerialNumber Serial number of the assigned device.
 * @property encodedValidationCertPubKey The base 64 encoded public key to authenticate with the device
 * @property networkConfigurations Network configuration of the appliance.
 */
public data class DataBoxHeavySecretResponse(
    public val accountCredentialDetails: List<AccountCredentialDetailsResponse>,
    public val devicePassword: String,
    public val deviceSerialNumber: String,
    public val encodedValidationCertPubKey: String,
    public val networkConfigurations: List<ApplianceNetworkConfigurationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DataBoxHeavySecretResponse):
            DataBoxHeavySecretResponse = DataBoxHeavySecretResponse(
            accountCredentialDetails = javaType.accountCredentialDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.AccountCredentialDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            devicePassword = javaType.devicePassword(),
            deviceSerialNumber = javaType.deviceSerialNumber(),
            encodedValidationCertPubKey = javaType.encodedValidationCertPubKey(),
            networkConfigurations = javaType.networkConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databox.kotlin.outputs.ApplianceNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
