@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Datacenter instruction for given storage location.
 * @property communicationInstruction Data center communication instruction
 * @property dataCenterAzureLocation Azure Location where the Data Center serves primarily.
 * @property datacenterAddressType Data center address type
 * Expected value is 'DatacenterAddressInstruction'.
 * @property supportedCarriersForReturnShipment List of supported carriers for return shipment.
 */
public data class DatacenterAddressInstructionResponseResponse(
    public val communicationInstruction: String,
    public val dataCenterAzureLocation: String,
    public val datacenterAddressType: String,
    public val supportedCarriersForReturnShipment: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.DatacenterAddressInstructionResponseResponse):
            DatacenterAddressInstructionResponseResponse = DatacenterAddressInstructionResponseResponse(
            communicationInstruction = javaType.communicationInstruction(),
            dataCenterAzureLocation = javaType.dataCenterAzureLocation(),
            datacenterAddressType = javaType.datacenterAddressType(),
            supportedCarriersForReturnShipment = javaType.supportedCarriersForReturnShipment().map({ args0 ->
                args0
            }),
        )
    }
}
