@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Notification preference for a job stage.
 * @property sendNotification Notification is required or not.
 * @property stageName Name of the stage.
 */
public data class NotificationPreferenceResponse(
    public val sendNotification: Boolean,
    public val stageName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.NotificationPreferenceResponse):
            NotificationPreferenceResponse = NotificationPreferenceResponse(
            sendNotification = javaType.sendNotification(),
            stageName = javaType.stageName(),
        )
    }
}
