@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databox.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Msi identity details of the resource
 * @property principalId Service Principal Id backing the Msi
 * @property tenantId Home Tenant Id
 * @property type Identity type
 * @property userAssignedIdentities User Assigned Identities
 */
public data class ResourceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databox.outputs.ResourceIdentityResponse):
            ResourceIdentityResponse = ResourceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.databox.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
