@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.EdgeProfileResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.EdgeProfileResponse.Companion.toKotlin as edgeProfileResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudEdgeManagementRole].
 */
@PulumiTagMarker
public class CloudEdgeManagementRoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudEdgeManagementRoleArgs = CloudEdgeManagementRoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudEdgeManagementRoleArgsBuilder.() -> Unit) {
        val builder = CloudEdgeManagementRoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CloudEdgeManagementRole {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.CloudEdgeManagementRole(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudEdgeManagementRole(builtJavaResource)
    }
}

/**
 * The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing VMs on your Azure Stack Edge device from Azure Portal.
 * For more information, refer to: https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview
 * By using this feature, you agree to the preview legal terms. See the https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### RolePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudEdgeManagementRole = new AzureNative.DataBoxEdge.CloudEdgeManagementRole("cloudEdgeManagementRole", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Name = "IoTRole1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewCloudEdgeManagementRole(ctx, "cloudEdgeManagementRole", &databoxedge.CloudEdgeManagementRoleArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("IoTRole1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.CloudEdgeManagementRole;
 * import com.pulumi.azurenative.databoxedge.CloudEdgeManagementRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudEdgeManagementRole = new CloudEdgeManagementRole("cloudEdgeManagementRole", CloudEdgeManagementRoleArgs.builder()
 *             .deviceName("testedgedevice")
 *             .name("IoTRole1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:CloudEdgeManagementRole IoTRole1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/roles/{name}
 * ```
 */
public class CloudEdgeManagementRole internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.CloudEdgeManagementRole,
) : KotlinCustomResource(javaResource, CloudEdgeManagementRoleMapper) {
    /**
     * Edge Profile of the resource
     */
    public val edgeProfile: Output<EdgeProfileResponse>
        get() = javaResource.edgeProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                edgeProfileResponseToKotlin(args0)
            })
        })

    /**
     * Role type.
     * Expected value is 'CloudEdgeManagement'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Local Edge Management Status
     */
    public val localManagementStatus: Output<String>
        get() = javaResource.localManagementStatus().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Role status.
     */
    public val roleStatus: Output<String>
        get() = javaResource.roleStatus().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of Role
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CloudEdgeManagementRoleMapper : ResourceMapper<CloudEdgeManagementRole> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.CloudEdgeManagementRole::class == javaResource::class

    override fun map(javaResource: Resource): CloudEdgeManagementRole =
        CloudEdgeManagementRole(
            javaResource as
                com.pulumi.azurenative.databoxedge.CloudEdgeManagementRole,
        )
}

/**
 * @see [CloudEdgeManagementRole].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudEdgeManagementRole].
 */
public suspend fun cloudEdgeManagementRole(
    name: String,
    block: suspend CloudEdgeManagementRoleResourceBuilder.() -> Unit,
): CloudEdgeManagementRole {
    val builder = CloudEdgeManagementRoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudEdgeManagementRole].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudEdgeManagementRole(name: String): CloudEdgeManagementRole {
    val builder = CloudEdgeManagementRoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
