@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.ContainerArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.AzureContainerDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a container on the  Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### ContainerPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var container = new AzureNative.DataBoxEdge.Container("container", new()
 *     {
 *         ContainerName = "blobcontainer1",
 *         DataFormat = AzureNative.DataBoxEdge.AzureContainerDataFormat.BlockBlob,
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         StorageAccountName = "storageaccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewContainer(ctx, "container", &databoxedge.ContainerArgs{
 * 			ContainerName:      pulumi.String("blobcontainer1"),
 * 			DataFormat:         pulumi.String(databoxedge.AzureContainerDataFormatBlockBlob),
 * 			DeviceName:         pulumi.String("testedgedevice"),
 * 			ResourceGroupName:  pulumi.String("GroupForEdgeAutomation"),
 * 			StorageAccountName: pulumi.String("storageaccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Container;
 * import com.pulumi.azurenative.databoxedge.ContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var container = new Container("container", ContainerArgs.builder()
 *             .containerName("blobcontainer1")
 *             .dataFormat("BlockBlob")
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .storageAccountName("storageaccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Container blobcontainer-5e155efe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccounts/{storageAccountName}/containers/{containerName}
 * ```
 * @property containerName The container name.
 * @property dataFormat DataFormat for Container
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 * @property storageAccountName The Storage Account Name
 */
public data class ContainerArgs(
    public val containerName: Output<String>? = null,
    public val dataFormat: Output<Either<String, AzureContainerDataFormat>>? = null,
    public val deviceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.ContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.ContainerArgs =
        com.pulumi.azurenative.databoxedge.ContainerArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerArgs].
 */
@PulumiTagMarker
public class ContainerArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var dataFormat: Output<Either<String, AzureContainerDataFormat>>? = null

    private var deviceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    /**
     * @param value The container name.
     */
    @JvmName("nminvflattywcnxd")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value DataFormat for Container
     */
    @JvmName("xbvlbvrgeuhpohrv")
    public suspend fun dataFormat(`value`: Output<Either<String, AzureContainerDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("cbulsaxxoycedwth")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("orajrmxfiemryodl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Storage Account Name
     */
    @JvmName("buugqtpiyrgplrfi")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value The container name.
     */
    @JvmName("hpunthaemkxvjhkb")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value DataFormat for Container
     */
    @JvmName("ukbohkrvrqfuvnlo")
    public suspend fun dataFormat(`value`: Either<String, AzureContainerDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value DataFormat for Container
     */
    @JvmName("ealuassdtbmmypbg")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureContainerDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value DataFormat for Container
     */
    @JvmName("xhbuhpdcnjobjioh")
    public fun dataFormat(`value`: AzureContainerDataFormat) {
        val toBeMapped = Either.ofRight<String, AzureContainerDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The device name.
     */
    @JvmName("bwnnoatxkjdhulfs")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("dhfwcbxxvtdgqocn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Storage Account Name
     */
    @JvmName("lmnqrfufdgatwrtj")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    internal fun build(): ContainerArgs = ContainerArgs(
        containerName = containerName,
        dataFormat = dataFormat,
        deviceName = deviceName,
        resourceGroupName = resourceGroupName,
        storageAccountName = storageAccountName,
    )
}
