@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.DataResidencyResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.EdgeProfileResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ResourceMoveDetailsResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.databoxedge.kotlin.outputs.DataResidencyResponse.Companion.toKotlin as dataResidencyResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.EdgeProfileResponse.Companion.toKotlin as edgeProfileResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.ResourceMoveDetailsResponse.Companion.toKotlin as resourceMoveDetailsResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Device].
 */
@PulumiTagMarker
public class DeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceArgs = DeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceArgsBuilder.() -> Unit) {
        val builder = DeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Device {
        val builtJavaResource = com.pulumi.azurenative.databoxedge.Device(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Device(builtJavaResource)
    }
}

/**
 * The Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-05-01-preview, 2021-02-01, 2021-02-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### DataBoxEdgeDevicePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.DataBoxEdge.Device("device", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         Location = "WUS",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         Sku = new AzureNative.DataBoxEdge.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DataBoxEdge.SkuName.Edge,
 *             Tier = AzureNative.DataBoxEdge.SkuTier.Standard,
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewDevice(ctx, "device", &databoxedge.DeviceArgs{
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Location:          pulumi.String("WUS"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			Sku: &databoxedge.SkuArgs{
 * 				Name: pulumi.String(databoxedge.SkuNameEdge),
 * 				Tier: pulumi.String(databoxedge.SkuTierStandard),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Device;
 * import com.pulumi.azurenative.databoxedge.DeviceArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .deviceName("testedgedevice")
 *             .location("WUS")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sku(SkuArgs.builder()
 *                 .name("Edge")
 *                 .tier("Standard")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### DataBoxEdgeDevicePutWithDataResidency
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.DataBoxEdge.Device("device", new()
 *     {
 *         DataResidency = new AzureNative.DataBoxEdge.Inputs.DataResidencyArgs
 *         {
 *             Type = AzureNative.DataBoxEdge.DataResidencyType.ZoneReplication,
 *         },
 *         DeviceName = "testedgedevice",
 *         Location = "WUS",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         Sku = new AzureNative.DataBoxEdge.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.DataBoxEdge.SkuName.Edge,
 *             Tier = AzureNative.DataBoxEdge.SkuTier.Standard,
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewDevice(ctx, "device", &databoxedge.DeviceArgs{
 * 			DataResidency: &databoxedge.DataResidencyArgs{
 * 				Type: pulumi.String(databoxedge.DataResidencyTypeZoneReplication),
 * 			},
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Location:          pulumi.String("WUS"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			Sku: &databoxedge.SkuArgs{
 * 				Name: pulumi.String(databoxedge.SkuNameEdge),
 * 				Tier: pulumi.String(databoxedge.SkuTierStandard),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Device;
 * import com.pulumi.azurenative.databoxedge.DeviceArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.DataResidencyArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .dataResidency(DataResidencyArgs.builder()
 *                 .type("ZoneReplication")
 *                 .build())
 *             .deviceName("testedgedevice")
 *             .location("WUS")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sku(SkuArgs.builder()
 *                 .name("Edge")
 *                 .tier("Standard")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Device testedgedevice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}
 * ```
 */
public class Device internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.Device,
) : KotlinCustomResource(javaResource, DeviceMapper) {
    /**
     * Type of compute roles configured.
     */
    public val configuredRoleTypes: Output<List<String>>
        get() = javaResource.configuredRoleTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Data Box Edge/Gateway device culture.
     */
    public val culture: Output<String>
        get() = javaResource.culture().applyValue({ args0 -> args0 })

    /**
     * The status of the Data Box Edge/Gateway device.
     */
    public val dataBoxEdgeDeviceStatus: Output<String>
        get() = javaResource.dataBoxEdgeDeviceStatus().applyValue({ args0 -> args0 })

    /**
     * The details of data-residency related properties for this resource
     */
    public val dataResidency: Output<DataResidencyResponse>?
        get() = javaResource.dataResidency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataResidencyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Description of the Data Box Edge/Gateway device.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The device software version number of the device (eg: 1.2.18105.6).
     */
    public val deviceHcsVersion: Output<String>
        get() = javaResource.deviceHcsVersion().applyValue({ args0 -> args0 })

    /**
     * The Data Box Edge/Gateway device local capacity in MB.
     */
    public val deviceLocalCapacity: Output<Double>
        get() = javaResource.deviceLocalCapacity().applyValue({ args0 -> args0 })

    /**
     * The Data Box Edge/Gateway device model.
     */
    public val deviceModel: Output<String>
        get() = javaResource.deviceModel().applyValue({ args0 -> args0 })

    /**
     * The Data Box Edge/Gateway device software version.
     */
    public val deviceSoftwareVersion: Output<String>
        get() = javaResource.deviceSoftwareVersion().applyValue({ args0 -> args0 })

    /**
     * The type of the Data Box Edge/Gateway device.
     */
    public val deviceType: Output<String>
        get() = javaResource.deviceType().applyValue({ args0 -> args0 })

    /**
     * The details of Edge Profile for this resource
     */
    public val edgeProfile: Output<EdgeProfileResponse>
        get() = javaResource.edgeProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                edgeProfileResponseToKotlin(args0)
            })
        })

    /**
     * The etag for the devices.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Data Box Edge/Gateway device name.
     */
    public val friendlyName: Output<String>
        get() = javaResource.friendlyName().applyValue({ args0 -> args0 })

    /**
     * Msi identity of the resource
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of the device.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The location of the device. This is a supported and registered Azure geographical region (for example, West US, East US, or Southeast Asia). The geographical region of a device cannot be changed once it is created, but if an identical geographical region is specified on update, the request will succeed.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The description of the Data Box Edge/Gateway device model.
     */
    public val modelDescription: Output<String>
        get() = javaResource.modelDescription().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of nodes in the cluster.
     */
    public val nodeCount: Output<Int>
        get() = javaResource.nodeCount().applyValue({ args0 -> args0 })

    /**
     * The details of the move operation on this resource.
     */
    public val resourceMoveDetails: Output<ResourceMoveDetailsResponse>
        get() = javaResource.resourceMoveDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceMoveDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The Serial Number of Data Box Edge/Gateway device.
     */
    public val serialNumber: Output<String>
        get() = javaResource.serialNumber().applyValue({ args0 -> args0 })

    /**
     * The SKU type.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * DataBoxEdge Resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Data Box Edge/Gateway device timezone.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeviceMapper : ResourceMapper<Device> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.Device::class == javaResource::class

    override fun map(javaResource: Resource): Device = Device(
        javaResource as
            com.pulumi.azurenative.databoxedge.Device,
    )
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Device].
 */
public suspend fun device(name: String, block: suspend DeviceResourceBuilder.() -> Unit): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 */
public fun device(name: String): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
