@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.FileSourceInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RoleSinkInfoResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.FileSourceInfoResponse.Companion.toKotlin as fileSourceInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.RoleSinkInfoResponse.Companion.toKotlin as roleSinkInfoResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FileEventTrigger].
 */
@PulumiTagMarker
public class FileEventTriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileEventTriggerArgs = FileEventTriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileEventTriggerArgsBuilder.() -> Unit) {
        val builder = FileEventTriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FileEventTrigger {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.FileEventTrigger(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FileEventTrigger(builtJavaResource)
    }
}

/**
 * Trigger details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * ## Example Usage
 * ### TriggerPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileEventTrigger = new AzureNative.DataBoxEdge.FileEventTrigger("fileEventTrigger", new()
 *     {
 *         CustomContextTag = "CustomContextTags-1235346475",
 *         DeviceName = "testedgedevice",
 *         Kind = "FileEvent",
 *         Name = "trigger1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         SinkInfo = new AzureNative.DataBoxEdge.Inputs.RoleSinkInfoArgs
 *         {
 *             RoleId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/roles/role1",
 *         },
 *         SourceInfo = new AzureNative.DataBoxEdge.Inputs.FileSourceInfoArgs
 *         {
 *             ShareId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/shares/share1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewFileEventTrigger(ctx, "fileEventTrigger", &databoxedge.FileEventTriggerArgs{
 * 			CustomContextTag:  pulumi.String("CustomContextTags-1235346475"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Kind:              pulumi.String("FileEvent"),
 * 			Name:              pulumi.String("trigger1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			SinkInfo: &databoxedge.RoleSinkInfoArgs{
 * 				RoleId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/roles/role1"),
 * 			},
 * 			SourceInfo: &databoxedge.FileSourceInfoArgs{
 * 				ShareId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/shares/share1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.FileEventTrigger;
 * import com.pulumi.azurenative.databoxedge.FileEventTriggerArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.RoleSinkInfoArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.FileSourceInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileEventTrigger = new FileEventTrigger("fileEventTrigger", FileEventTriggerArgs.builder()
 *             .customContextTag("CustomContextTags-1235346475")
 *             .deviceName("testedgedevice")
 *             .kind("FileEvent")
 *             .name("trigger1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sinkInfo(RoleSinkInfoArgs.builder()
 *                 .roleId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/roles/role1")
 *                 .build())
 *             .sourceInfo(FileSourceInfoArgs.builder()
 *                 .shareId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/GroupForEdgeAutomation/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/testedgedevice/shares/share1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:FileEventTrigger trigger1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/triggers/{name}
 * ```
 */
public class FileEventTrigger internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.FileEventTrigger,
) : KotlinCustomResource(javaResource, FileEventTriggerMapper) {
    /**
     * A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger is intended for certain specific IoT modules in the device, the tag can be the name or the image URL of the module.
     */
    public val customContextTag: Output<String>?
        get() = javaResource.customContextTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trigger Kind.
     * Expected value is 'FileEvent'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Role sink info.
     */
    public val sinkInfo: Output<RoleSinkInfoResponse>
        get() = javaResource.sinkInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                roleSinkInfoResponseToKotlin(args0)
            })
        })

    /**
     * File event source details.
     */
    public val sourceInfo: Output<FileSourceInfoResponse>
        get() = javaResource.sourceInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                fileSourceInfoResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of Trigger
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FileEventTriggerMapper : ResourceMapper<FileEventTrigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.FileEventTrigger::class == javaResource::class

    override fun map(javaResource: Resource): FileEventTrigger = FileEventTrigger(
        javaResource as
            com.pulumi.azurenative.databoxedge.FileEventTrigger,
    )
}

/**
 * @see [FileEventTrigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileEventTrigger].
 */
public suspend fun fileEventTrigger(
    name: String,
    block: suspend FileEventTriggerResourceBuilder.() -> Unit,
): FileEventTrigger {
    val builder = FileEventTriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileEventTrigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileEventTrigger(name: String): FileEventTrigger {
    val builder = FileEventTriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
