@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.OrderArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.ShipmentType
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AddressArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AddressArgsBuilder
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ContactDetailsArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.ContactDetailsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The order details.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-05-01-preview, 2022-04-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### OrderPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var order = new AzureNative.DataBoxEdge.Order("order", new()
 *     {
 *         ContactInformation = new AzureNative.DataBoxEdge.Inputs.ContactDetailsArgs
 *         {
 *             CompanyName = "Microsoft",
 *             ContactPerson = "John Mcclane",
 *             EmailList = new[]
 *             {
 *                 "john@microsoft.com",
 *             },
 *             Phone = "(800) 426-9400",
 *         },
 *         DeviceName = "testedgedevice",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         ShippingAddress = new AzureNative.DataBoxEdge.Inputs.AddressArgs
 *         {
 *             AddressLine1 = "Microsoft Corporation",
 *             AddressLine2 = "One Microsoft Way",
 *             AddressLine3 = "Redmond",
 *             City = "WA",
 *             Country = "USA",
 *             PostalCode = "98052",
 *             State = "WA",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewOrder(ctx, "order", &databoxedge.OrderArgs{
 * 			ContactInformation: &databoxedge.ContactDetailsArgs{
 * 				CompanyName:   pulumi.String("Microsoft"),
 * 				ContactPerson: pulumi.String("John Mcclane"),
 * 				EmailList: pulumi.StringArray{
 * 					pulumi.String("john@microsoft.com"),
 * 				},
 * 				Phone: pulumi.String("(800) 426-9400"),
 * 			},
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			ShippingAddress: &databoxedge.AddressArgs{
 * 				AddressLine1: pulumi.String("Microsoft Corporation"),
 * 				AddressLine2: pulumi.String("One Microsoft Way"),
 * 				AddressLine3: pulumi.String("Redmond"),
 * 				City:         pulumi.String("WA"),
 * 				Country:      pulumi.String("USA"),
 * 				PostalCode:   pulumi.String("98052"),
 * 				State:        pulumi.String("WA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.Order;
 * import com.pulumi.azurenative.databoxedge.OrderArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.ContactDetailsArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.AddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var order = new Order("order", OrderArgs.builder()
 *             .contactInformation(ContactDetailsArgs.builder()
 *                 .companyName("Microsoft")
 *                 .contactPerson("John Mcclane")
 *                 .emailList("john@microsoft.com")
 *                 .phone("(800) 426-9400")
 *                 .build())
 *             .deviceName("testedgedevice")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .shippingAddress(AddressArgs.builder()
 *                 .addressLine1("Microsoft Corporation")
 *                 .addressLine2("One Microsoft Way")
 *                 .addressLine3("Redmond")
 *                 .city("WA")
 *                 .country("USA")
 *                 .postalCode("98052")
 *                 .state("WA")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:Order default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/orders/default
 * ```
 * @property contactInformation The contact details.
 * @property deviceName The order details of a device.
 * @property resourceGroupName The resource group name.
 * @property shipmentType ShipmentType of the order
 * @property shippingAddress The shipping address.
 */
public data class OrderArgs(
    public val contactInformation: Output<ContactDetailsArgs>? = null,
    public val deviceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shipmentType: Output<Either<String, ShipmentType>>? = null,
    public val shippingAddress: Output<AddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.OrderArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.OrderArgs =
        com.pulumi.azurenative.databoxedge.OrderArgs.builder()
            .contactInformation(
                contactInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shipmentType(
                shipmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OrderArgs].
 */
@PulumiTagMarker
public class OrderArgsBuilder internal constructor() {
    private var contactInformation: Output<ContactDetailsArgs>? = null

    private var deviceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shipmentType: Output<Either<String, ShipmentType>>? = null

    private var shippingAddress: Output<AddressArgs>? = null

    /**
     * @param value The contact details.
     */
    @JvmName("txtgrohoalwqobee")
    public suspend fun contactInformation(`value`: Output<ContactDetailsArgs>) {
        this.contactInformation = value
    }

    /**
     * @param value The order details of a device.
     */
    @JvmName("hqjowgewsyguxrsl")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tdmewjfvgtxueryr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value ShipmentType of the order
     */
    @JvmName("lamcnaddgmhpatyu")
    public suspend fun shipmentType(`value`: Output<Either<String, ShipmentType>>) {
        this.shipmentType = value
    }

    /**
     * @param value The shipping address.
     */
    @JvmName("excbkrqtxghqkvsi")
    public suspend fun shippingAddress(`value`: Output<AddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value The contact details.
     */
    @JvmName("sfdxvcqanmrpxkeu")
    public suspend fun contactInformation(`value`: ContactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactInformation = mapped
    }

    /**
     * @param argument The contact details.
     */
    @JvmName("ydelgqrprssjaiwe")
    public suspend fun contactInformation(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactInformation = mapped
    }

    /**
     * @param value The order details of a device.
     */
    @JvmName("bikgcvlddphqtros")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eixmfcjqtnpbiolg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value ShipmentType of the order
     */
    @JvmName("bjavcxcrryirnivy")
    public suspend fun shipmentType(`value`: Either<String, ShipmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shipmentType = mapped
    }

    /**
     * @param value ShipmentType of the order
     */
    @JvmName("fltwmhehevtqidqm")
    public fun shipmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShipmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shipmentType = mapped
    }

    /**
     * @param value ShipmentType of the order
     */
    @JvmName("cergerjthiocmyup")
    public fun shipmentType(`value`: ShipmentType) {
        val toBeMapped = Either.ofRight<String, ShipmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shipmentType = mapped
    }

    /**
     * @param value The shipping address.
     */
    @JvmName("cbotghoqfbviuvrq")
    public suspend fun shippingAddress(`value`: AddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument The shipping address.
     */
    @JvmName("tgasygbiiodrpgvv")
    public suspend fun shippingAddress(argument: suspend AddressArgsBuilder.() -> Unit) {
        val toBeMapped = AddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): OrderArgs = OrderArgs(
        contactInformation = contactInformation,
        deviceName = deviceName,
        resourceGroupName = resourceGroupName,
        shipmentType = shipmentType,
        shippingAddress = shippingAddress,
    )
}
