@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databoxedge.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin as asymmetricEncryptedSecretResponseToKotlin
import com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StorageAccountCredential].
 */
@PulumiTagMarker
public class StorageAccountCredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageAccountCredentialArgs = StorageAccountCredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageAccountCredentialArgsBuilder.() -> Unit) {
        val builder = StorageAccountCredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageAccountCredential {
        val builtJavaResource =
            com.pulumi.azurenative.databoxedge.StorageAccountCredential(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageAccountCredential(builtJavaResource)
    }
}

/**
 * The storage account credential.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### SACPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccountCredential = new AzureNative.DataBoxEdge.StorageAccountCredential("storageAccountCredential", new()
 *     {
 *         AccountKey = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = AzureNative.DataBoxEdge.EncryptionAlgorithm.AES256,
 *             EncryptionCertThumbprint = "2A9D8D6BE51574B5461230AEF02F162C5F01AD31",
 *             Value = "lAeZEYi6rNP1/EyNaVUYmTSZEYyaIaWmwUsGwek0+xiZj54GM9Ue9/UA2ed/ClC03wuSit2XzM/cLRU5eYiFBwks23rGwiQOr3sruEL2a74EjPD050xYjA6M1I2hu/w2yjVHhn5j+DbXS4Xzi+rHHNZK3DgfDO3PkbECjPck+PbpSBjy9+6Mrjcld5DIZhUAeMlMHrFlg+WKRKB14o/og56u5/xX6WKlrMLEQ+y6E18dUwvWs2elTNoVO8PBE8SM/CfooX4AMNvaNdSObNBPdP+F6Lzc556nFNWXrBLRt0vC7s9qTiVRO4x/qCNaK/B4y7IqXMllwQFf4Np9UQ2ECA==",
 *         },
 *         AccountType = AzureNative.DataBoxEdge.AccountType.BlobStorage,
 *         Alias = "sac1",
 *         DeviceName = "testedgedevice",
 *         Name = "sac1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         SslStatus = AzureNative.DataBoxEdge.SSLStatus.Disabled,
 *         UserName = "cisbvt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewStorageAccountCredential(ctx, "storageAccountCredential", &databoxedge.StorageAccountCredentialArgs{
 * 			AccountKey: &databoxedge.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      pulumi.String(databoxedge.EncryptionAlgorithmAES256),
 * 				EncryptionCertThumbprint: pulumi.String("2A9D8D6BE51574B5461230AEF02F162C5F01AD31"),
 * 				Value:                    pulumi.String("lAeZEYi6rNP1/EyNaVUYmTSZEYyaIaWmwUsGwek0+xiZj54GM9Ue9/UA2ed/ClC03wuSit2XzM/cLRU5eYiFBwks23rGwiQOr3sruEL2a74EjPD050xYjA6M1I2hu/w2yjVHhn5j+DbXS4Xzi+rHHNZK3DgfDO3PkbECjPck+PbpSBjy9+6Mrjcld5DIZhUAeMlMHrFlg+WKRKB14o/og56u5/xX6WKlrMLEQ+y6E18dUwvWs2elTNoVO8PBE8SM/CfooX4AMNvaNdSObNBPdP+F6Lzc556nFNWXrBLRt0vC7s9qTiVRO4x/qCNaK/B4y7IqXMllwQFf4Np9UQ2ECA=="),
 * 			},
 * 			AccountType:       pulumi.String(databoxedge.AccountTypeBlobStorage),
 * 			Alias:             pulumi.String("sac1"),
 * 			DeviceName:        pulumi.String("testedgedevice"),
 * 			Name:              pulumi.String("sac1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			SslStatus:         pulumi.String(databoxedge.SSLStatusDisabled),
 * 			UserName:          pulumi.String("cisbvt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.StorageAccountCredential;
 * import com.pulumi.azurenative.databoxedge.StorageAccountCredentialArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccountCredential = new StorageAccountCredential("storageAccountCredential", StorageAccountCredentialArgs.builder()
 *             .accountKey(AsymmetricEncryptedSecretArgs.builder()
 *                 .encryptionAlgorithm("AES256")
 *                 .encryptionCertThumbprint("2A9D8D6BE51574B5461230AEF02F162C5F01AD31")
 *                 .value("lAeZEYi6rNP1/EyNaVUYmTSZEYyaIaWmwUsGwek0+xiZj54GM9Ue9/UA2ed/ClC03wuSit2XzM/cLRU5eYiFBwks23rGwiQOr3sruEL2a74EjPD050xYjA6M1I2hu/w2yjVHhn5j+DbXS4Xzi+rHHNZK3DgfDO3PkbECjPck+PbpSBjy9+6Mrjcld5DIZhUAeMlMHrFlg+WKRKB14o/og56u5/xX6WKlrMLEQ+y6E18dUwvWs2elTNoVO8PBE8SM/CfooX4AMNvaNdSObNBPdP+F6Lzc556nFNWXrBLRt0vC7s9qTiVRO4x/qCNaK/B4y7IqXMllwQFf4Np9UQ2ECA==")
 *                 .build())
 *             .accountType("BlobStorage")
 *             .alias("sac1")
 *             .deviceName("testedgedevice")
 *             .name("sac1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .sslStatus("Disabled")
 *             .userName("cisbvt")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:StorageAccountCredential sac1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/storageAccountCredentials/{name}
 * ```
 */
public class StorageAccountCredential internal constructor(
    override val javaResource: com.pulumi.azurenative.databoxedge.StorageAccountCredential,
) : KotlinCustomResource(javaResource, StorageAccountCredentialMapper) {
    /**
     * Encrypted storage key.
     */
    public val accountKey: Output<AsymmetricEncryptedSecretResponse>?
        get() = javaResource.accountKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    asymmetricEncryptedSecretResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of storage accessed on the storage account.
     */
    public val accountType: Output<String>
        get() = javaResource.accountType().applyValue({ args0 -> args0 })

    /**
     * Alias for the storage account.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * Blob end point for private clouds.
     */
    public val blobDomainName: Output<String>?
        get() = javaResource.blobDomainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connection string for the storage account. Use this string if username and account key are not specified.
     */
    public val connectionString: Output<String>?
        get() = javaResource.connectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The object name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Signifies whether SSL needs to be enabled or not.
     */
    public val sslStatus: Output<String>
        get() = javaResource.sslStatus().applyValue({ args0 -> args0 })

    /**
     * Id of the storage account.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of StorageAccountCredential
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Username for the storage account.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object StorageAccountCredentialMapper : ResourceMapper<StorageAccountCredential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databoxedge.StorageAccountCredential::class == javaResource::class

    override fun map(javaResource: Resource): StorageAccountCredential =
        StorageAccountCredential(
            javaResource as
                com.pulumi.azurenative.databoxedge.StorageAccountCredential,
        )
}

/**
 * @see [StorageAccountCredential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageAccountCredential].
 */
public suspend fun storageAccountCredential(
    name: String,
    block: suspend StorageAccountCredentialResourceBuilder.() -> Unit,
): StorageAccountCredential {
    val builder = StorageAccountCredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageAccountCredential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageAccountCredential(name: String): StorageAccountCredential {
    val builder = StorageAccountCredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
