@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin

import com.pulumi.azurenative.databoxedge.UserArgs.builder
import com.pulumi.azurenative.databoxedge.kotlin.enums.UserType
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AsymmetricEncryptedSecretArgs
import com.pulumi.azurenative.databoxedge.kotlin.inputs.AsymmetricEncryptedSecretArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
 * Azure REST API version: 2022-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-07-01, 2019-08-01, 2021-02-01-preview, 2023-01-01-preview, 2023-07-01, 2023-12-01.
 * ## Example Usage
 * ### UserPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.DataBoxEdge.User("user", new()
 *     {
 *         DeviceName = "testedgedevice",
 *         EncryptedPassword = new AzureNative.DataBoxEdge.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = AzureNative.DataBoxEdge.EncryptionAlgorithm.None,
 *             EncryptionCertThumbprint = "blah",
 *             Value = "<value>",
 *         },
 *         Name = "user1",
 *         ResourceGroupName = "GroupForEdgeAutomation",
 *         UserType = AzureNative.DataBoxEdge.UserType.Share,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databoxedge/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databoxedge.NewUser(ctx, "user", &databoxedge.UserArgs{
 * 			DeviceName: pulumi.String("testedgedevice"),
 * 			EncryptedPassword: &databoxedge.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      pulumi.String(databoxedge.EncryptionAlgorithmNone),
 * 				EncryptionCertThumbprint: pulumi.String("blah"),
 * 				Value:                    pulumi.String("<value>"),
 * 			},
 * 			Name:              pulumi.String("user1"),
 * 			ResourceGroupName: pulumi.String("GroupForEdgeAutomation"),
 * 			UserType:          pulumi.String(databoxedge.UserTypeShare),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databoxedge.User;
 * import com.pulumi.azurenative.databoxedge.UserArgs;
 * import com.pulumi.azurenative.databoxedge.inputs.AsymmetricEncryptedSecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .deviceName("testedgedevice")
 *             .encryptedPassword(AsymmetricEncryptedSecretArgs.builder()
 *                 .encryptionAlgorithm("None")
 *                 .encryptionCertThumbprint("blah")
 *                 .value("<value>")
 *                 .build())
 *             .name("user1")
 *             .resourceGroupName("GroupForEdgeAutomation")
 *             .userType("Share")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databoxedge:User user1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/users/{name}
 * ```
 * @property deviceName The device name.
 * @property encryptedPassword The password details.
 * @property name The user name.
 * @property resourceGroupName The resource group name.
 * @property userType Type of the user.
 */
public data class UserArgs(
    public val deviceName: Output<String>? = null,
    public val encryptedPassword: Output<AsymmetricEncryptedSecretArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val userType: Output<Either<String, UserType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.UserArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.UserArgs =
        com.pulumi.azurenative.databoxedge.UserArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .encryptedPassword(encryptedPassword?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .userType(
                userType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var encryptedPassword: Output<AsymmetricEncryptedSecretArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var userType: Output<Either<String, UserType>>? = null

    /**
     * @param value The device name.
     */
    @JvmName("ifuccaciftiuqqon")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The password details.
     */
    @JvmName("tngajlhhajyfdure")
    public suspend fun encryptedPassword(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.encryptedPassword = value
    }

    /**
     * @param value The user name.
     */
    @JvmName("bfxcpmphcqoglmle")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eaornekmtwlcnenl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Type of the user.
     */
    @JvmName("natlusiclqfxmnbb")
    public suspend fun userType(`value`: Output<Either<String, UserType>>) {
        this.userType = value
    }

    /**
     * @param value The device name.
     */
    @JvmName("njsptkksstevaoyq")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The password details.
     */
    @JvmName("dtecnxlpliaiijlc")
    public suspend fun encryptedPassword(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedPassword = mapped
    }

    /**
     * @param argument The password details.
     */
    @JvmName("mrualqmeaowlchmc")
    public suspend
    fun encryptedPassword(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptedPassword = mapped
    }

    /**
     * @param value The user name.
     */
    @JvmName("tlxxnhgwghikrxwv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sxklavydsntdxhft")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Type of the user.
     */
    @JvmName("aufkcutttyiafcrc")
    public suspend fun userType(`value`: Either<String, UserType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userType = mapped
    }

    /**
     * @param value Type of the user.
     */
    @JvmName("upaxstxesbbcjqam")
    public fun userType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userType = mapped
    }

    /**
     * @param value Type of the user.
     */
    @JvmName("ejktyvybhmudtiik")
    public fun userType(`value`: UserType) {
        val toBeMapped = Either.ofRight<String, UserType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userType = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        deviceName = deviceName,
        encryptedPassword = encryptedPassword,
        name = name,
        resourceGroupName = resourceGroupName,
        userType = userType,
    )
}
