@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.ContactDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contains all the contact details of the customer.
 * @property companyName The name of the company.
 * @property contactPerson The contact person name.
 * @property emailList The email list.
 * @property phone The phone number.
 */
public data class ContactDetailsArgs(
    public val companyName: Output<String>,
    public val contactPerson: Output<String>,
    public val emailList: Output<List<String>>,
    public val phone: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.ContactDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.ContactDetailsArgs =
        com.pulumi.azurenative.databoxedge.inputs.ContactDetailsArgs.builder()
            .companyName(companyName.applyValue({ args0 -> args0 }))
            .contactPerson(contactPerson.applyValue({ args0 -> args0 }))
            .emailList(emailList.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .phone(phone.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactDetailsArgs].
 */
@PulumiTagMarker
public class ContactDetailsArgsBuilder internal constructor() {
    private var companyName: Output<String>? = null

    private var contactPerson: Output<String>? = null

    private var emailList: Output<List<String>>? = null

    private var phone: Output<String>? = null

    /**
     * @param value The name of the company.
     */
    @JvmName("upqkgfiwutbprscq")
    public suspend fun companyName(`value`: Output<String>) {
        this.companyName = value
    }

    /**
     * @param value The contact person name.
     */
    @JvmName("xsxpdohjpehsdulm")
    public suspend fun contactPerson(`value`: Output<String>) {
        this.contactPerson = value
    }

    /**
     * @param value The email list.
     */
    @JvmName("wpcejybmfxrmhchd")
    public suspend fun emailList(`value`: Output<List<String>>) {
        this.emailList = value
    }

    @JvmName("fhpirhotikqyvlng")
    public suspend fun emailList(vararg values: Output<String>) {
        this.emailList = Output.all(values.asList())
    }

    /**
     * @param values The email list.
     */
    @JvmName("djnllifqpekyjvin")
    public suspend fun emailList(values: List<Output<String>>) {
        this.emailList = Output.all(values)
    }

    /**
     * @param value The phone number.
     */
    @JvmName("ccqgkbblrsccipjg")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value The name of the company.
     */
    @JvmName("qrfvxlquftiyjwva")
    public suspend fun companyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.companyName = mapped
    }

    /**
     * @param value The contact person name.
     */
    @JvmName("tmwyrbmpfqxrxidn")
    public suspend fun contactPerson(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactPerson = mapped
    }

    /**
     * @param value The email list.
     */
    @JvmName("cjoxvltvpgyhgelp")
    public suspend fun emailList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailList = mapped
    }

    /**
     * @param values The email list.
     */
    @JvmName("irurfnqfuxtgqdeu")
    public suspend fun emailList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailList = mapped
    }

    /**
     * @param value The phone number.
     */
    @JvmName("ektqgvxsusqmcnlw")
    public suspend fun phone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    internal fun build(): ContactDetailsArgs = ContactDetailsArgs(
        companyName = companyName ?: throw PulumiNullFieldException("companyName"),
        contactPerson = contactPerson ?: throw PulumiNullFieldException("contactPerson"),
        emailList = emailList ?: throw PulumiNullFieldException("emailList"),
        phone = phone ?: throw PulumiNullFieldException("phone"),
    )
}
