@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.GetMonitoringConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name.
 * @property resourceGroupName The resource group name.
 * @property roleName The role name.
 */
public data class GetMonitoringConfigPlainArgs(
    public val deviceName: String,
    public val resourceGroupName: String,
    public val roleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.GetMonitoringConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.GetMonitoringConfigPlainArgs =
        com.pulumi.azurenative.databoxedge.inputs.GetMonitoringConfigPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .roleName(roleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMonitoringConfigPlainArgs].
 */
@PulumiTagMarker
public class GetMonitoringConfigPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    private var roleName: String? = null

    /**
     * @param value The device name.
     */
    @JvmName("phdcdkbnlewpatvv")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("fpuhpyeglyhtacey")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("vtjsxnajkhdhmgav")
    public suspend fun roleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleName = mapped
    }

    internal fun build(): GetMonitoringConfigPlainArgs = GetMonitoringConfigPlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        roleName = roleName ?: throw PulumiNullFieldException("roleName"),
    )
}
