@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.IoTEdgeAgentInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping IoT Role if specified.
 * @property imageName Name of the IoT edge agent image.
 * @property imageRepository Image repository details.
 * @property tag Image Tag.
 */
public data class IoTEdgeAgentInfoArgs(
    public val imageName: Output<String>,
    public val imageRepository: Output<ImageRepositoryCredentialArgs>? = null,
    public val tag: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.IoTEdgeAgentInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.IoTEdgeAgentInfoArgs =
        com.pulumi.azurenative.databoxedge.inputs.IoTEdgeAgentInfoArgs.builder()
            .imageName(imageName.applyValue({ args0 -> args0 }))
            .imageRepository(imageRepository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tag(tag.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IoTEdgeAgentInfoArgs].
 */
@PulumiTagMarker
public class IoTEdgeAgentInfoArgsBuilder internal constructor() {
    private var imageName: Output<String>? = null

    private var imageRepository: Output<ImageRepositoryCredentialArgs>? = null

    private var tag: Output<String>? = null

    /**
     * @param value Name of the IoT edge agent image.
     */
    @JvmName("ymwcmibfiugvemks")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Image repository details.
     */
    @JvmName("kwchxuwapuqybxkn")
    public suspend fun imageRepository(`value`: Output<ImageRepositoryCredentialArgs>) {
        this.imageRepository = value
    }

    /**
     * @param value Image Tag.
     */
    @JvmName("unhtawwgvbvpdjjt")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value Name of the IoT edge agent image.
     */
    @JvmName("fofofivsjgpyxsru")
    public suspend fun imageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Image repository details.
     */
    @JvmName("xgvmukhfxtxrdhbi")
    public suspend fun imageRepository(`value`: ImageRepositoryCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRepository = mapped
    }

    /**
     * @param argument Image repository details.
     */
    @JvmName("qwonekynfsumwolk")
    public suspend
    fun imageRepository(argument: suspend ImageRepositoryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = ImageRepositoryCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageRepository = mapped
    }

    /**
     * @param value Image Tag.
     */
    @JvmName("nglbbbbwpjduarev")
    public suspend fun tag(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): IoTEdgeAgentInfoArgs = IoTEdgeAgentInfoArgs(
        imageName = imageName ?: throw PulumiNullFieldException("imageName"),
        imageRepository = imageRepository,
        tag = tag ?: throw PulumiNullFieldException("tag"),
    )
}
