@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleComputeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kubernetes role compute resource
 * @property vmProfile VM profile
 */
public data class KubernetesRoleComputeArgs(
    public val vmProfile: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleComputeArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleComputeArgs =
        com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleComputeArgs.builder()
            .vmProfile(vmProfile.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KubernetesRoleComputeArgs].
 */
@PulumiTagMarker
public class KubernetesRoleComputeArgsBuilder internal constructor() {
    private var vmProfile: Output<String>? = null

    /**
     * @param value VM profile
     */
    @JvmName("masggttemsogkbsy")
    public suspend fun vmProfile(`value`: Output<String>) {
        this.vmProfile = value
    }

    /**
     * @param value VM profile
     */
    @JvmName("vsbvmytguxpxouep")
    public suspend fun vmProfile(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmProfile = mapped
    }

    internal fun build(): KubernetesRoleComputeArgs = KubernetesRoleComputeArgs(
        vmProfile = vmProfile ?: throw PulumiNullFieldException("vmProfile"),
    )
}
