@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.inputs

import com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Kubernetes role storage resource
 * @property endpoints Mount points of shares in role(s).
 */
public data class KubernetesRoleStorageArgs(
    public val endpoints: Output<List<MountPointMapArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleStorageArgs =
        com.pulumi.azurenative.databoxedge.inputs.KubernetesRoleStorageArgs.builder()
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [KubernetesRoleStorageArgs].
 */
@PulumiTagMarker
public class KubernetesRoleStorageArgsBuilder internal constructor() {
    private var endpoints: Output<List<MountPointMapArgs>>? = null

    /**
     * @param value Mount points of shares in role(s).
     */
    @JvmName("fncanspphqmsqdgy")
    public suspend fun endpoints(`value`: Output<List<MountPointMapArgs>>) {
        this.endpoints = value
    }

    @JvmName("lldevumgxkuyjkis")
    public suspend fun endpoints(vararg values: Output<MountPointMapArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values Mount points of shares in role(s).
     */
    @JvmName("gcxehmrvdwvqrpvq")
    public suspend fun endpoints(values: List<Output<MountPointMapArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value Mount points of shares in role(s).
     */
    @JvmName("jbglhrkomtllvjup")
    public suspend fun endpoints(`value`: List<MountPointMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument Mount points of shares in role(s).
     */
    @JvmName("yrsrispeyswidqqi")
    public suspend fun endpoints(argument: List<suspend MountPointMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MountPointMapArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument Mount points of shares in role(s).
     */
    @JvmName("rjpqpewypdvikfts")
    public suspend fun endpoints(vararg argument: suspend MountPointMapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MountPointMapArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument Mount points of shares in role(s).
     */
    @JvmName("irydkpkkyoslqnqw")
    public suspend fun endpoints(argument: suspend MountPointMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MountPointMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values Mount points of shares in role(s).
     */
    @JvmName("msawdpgaxsildkoy")
    public suspend fun endpoints(vararg values: MountPointMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    internal fun build(): KubernetesRoleStorageArgs = KubernetesRoleStorageArgs(
        endpoints = endpoints,
    )
}
