@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Compute infrastructure Resource
 * @property memoryInGB Memory in GB
 * @property processorCount Processor count
 */
public data class ComputeResourceResponse(
    public val memoryInGB: Double,
    public val processorCount: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ComputeResourceResponse):
            ComputeResourceResponse = ComputeResourceResponse(
            memoryInGB = javaType.memoryInGB(),
            processorCount = javaType.processorCount(),
        )
    }
}
