@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IoT Addon.
 * @property hostPlatform Host OS supported by the IoT addon.
 * @property hostPlatformType Platform where the runtime is hosted.
 * @property id The path ID that uniquely identifies the object.
 * @property ioTDeviceDetails IoT device metadata to which appliance needs to be connected.
 * @property ioTEdgeDeviceDetails IoT edge device to which the IoT Addon needs to be configured.
 * @property kind Addon type.
 * Expected value is 'IotEdge'.
 * @property name The object name.
 * @property provisioningState Addon Provisioning State
 * @property systemData Metadata pertaining to creation and last modification of Addon
 * @property type The hierarchical type of the object.
 * @property version Version of IoT running on the appliance.
 */
public data class GetIoTAddonResult(
    public val hostPlatform: String,
    public val hostPlatformType: String,
    public val id: String,
    public val ioTDeviceDetails: IoTDeviceInfoResponse,
    public val ioTEdgeDeviceDetails: IoTDeviceInfoResponse,
    public val kind: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetIoTAddonResult):
            GetIoTAddonResult = GetIoTAddonResult(
            hostPlatform = javaType.hostPlatform(),
            hostPlatformType = javaType.hostPlatformType(),
            id = javaType.id(),
            ioTDeviceDetails = javaType.ioTDeviceDetails().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse.Companion.toKotlin(args0)
            }),
            ioTEdgeDeviceDetails = javaType.ioTEdgeDeviceDetails().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.IoTDeviceInfoResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
