@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a share on the  Data Box Edge/Gateway device.
 * @property accessProtocol Access protocol to be used by the share.
 * @property azureContainerInfo Azure container mapping for the share.
 * @property clientAccessRights List of IP addresses and corresponding access rights on the share(required for NFS protocol).
 * @property dataPolicy Data policy of the share.
 * @property description Description for the share.
 * @property id The path ID that uniquely identifies the object.
 * @property monitoringStatus Current monitoring status of the share.
 * @property name The object name.
 * @property refreshDetails Details of the refresh job on this share.
 * @property shareMappings Share mount point to the role.
 * @property shareStatus Current status of the share.
 * @property systemData Metadata pertaining to creation and last modification of Share
 * @property type The hierarchical type of the object.
 * @property userAccessRights Mapping of users and corresponding access rights on the share (required for SMB protocol).
 */
public data class GetShareResult(
    public val accessProtocol: String,
    public val azureContainerInfo: AzureContainerInfoResponse? = null,
    public val clientAccessRights: List<ClientAccessRightResponse>? = null,
    public val dataPolicy: String? = null,
    public val description: String? = null,
    public val id: String,
    public val monitoringStatus: String,
    public val name: String,
    public val refreshDetails: RefreshDetailsResponse? = null,
    public val shareMappings: List<MountPointMapResponse>,
    public val shareStatus: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val userAccessRights: List<UserAccessRightResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.GetShareResult):
            GetShareResult = GetShareResult(
            accessProtocol = javaType.accessProtocol(),
            azureContainerInfo = javaType.azureContainerInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AzureContainerInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clientAccessRights = javaType.clientAccessRights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.ClientAccessRightResponse.Companion.toKotlin(args0)
                })
            }),
            dataPolicy = javaType.dataPolicy().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            monitoringStatus = javaType.monitoringStatus(),
            name = javaType.name(),
            refreshDetails = javaType.refreshDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.RefreshDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            shareMappings = javaType.shareMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MountPointMapResponse.Companion.toKotlin(args0)
                })
            }),
            shareStatus = javaType.shareStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.databoxedge.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            userAccessRights = javaType.userAccessRights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.UserAccessRightResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
