@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata of IoT device/IoT Edge device to be configured.
 * @property authentication Encrypted IoT device/IoT edge device connection string.
 * @property deviceId ID of the IoT device/edge device.
 * @property ioTHostHub Host name for the IoT hub associated to the device.
 * @property ioTHostHubId Id for the IoT hub associated to the device.
 */
public data class IoTDeviceInfoResponse(
    public val authentication: AuthenticationResponse? = null,
    public val deviceId: String,
    public val ioTHostHub: String,
    public val ioTHostHubId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.IoTDeviceInfoResponse):
            IoTDeviceInfoResponse = IoTDeviceInfoResponse(
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.AuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deviceId = javaType.deviceId(),
            ioTHostHub = javaType.ioTHostHub(),
            ioTHostHubId = javaType.ioTHostHubId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
