@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The metric counter
 * @property additionalDimensions The additional dimensions to be added to metric.
 * @property dimensionFilter The dimension filter.
 * @property instance The instance from which counter should be collected.
 * @property name The counter name.
 */
public data class MetricCounterResponse(
    public val additionalDimensions: List<MetricDimensionResponse>? = null,
    public val dimensionFilter: List<MetricDimensionResponse>? = null,
    public val instance: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.MetricCounterResponse):
            MetricCounterResponse = MetricCounterResponse(
            additionalDimensions = javaType.additionalDimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MetricDimensionResponse.Companion.toKotlin(args0)
                })
            }),
            dimensionFilter = javaType.dimensionFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databoxedge.kotlin.outputs.MetricDimensionResponse.Companion.toKotlin(args0)
                })
            }),
            instance = javaType.instance().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
