@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin

import com.pulumi.azurenative.databricks.kotlin.outputs.AddressSpaceResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.VirtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetwork
import com.pulumi.azurenative.databricks.kotlin.outputs.VirtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetwork
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databricks.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin as addressSpaceResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.VirtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetwork.Companion.toKotlin as virtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetworkToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.VirtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetwork.Companion.toKotlin as virtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetworkToKotlin

/**
 * Builder for [VNetPeering].
 */
@PulumiTagMarker
public class VNetPeeringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VNetPeeringArgs = VNetPeeringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VNetPeeringArgsBuilder.() -> Unit) {
        val builder = VNetPeeringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VNetPeering {
        val builtJavaResource = com.pulumi.azurenative.databricks.VNetPeering(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VNetPeering(builtJavaResource)
    }
}

/**
 * Peerings in a VirtualNetwork resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2018-04-01.
 * ## Example Usage
 * ### Create vNet Peering for Workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vNetPeering = new AzureNative.Databricks.VNetPeering("vNetPeering", new()
 *     {
 *         AllowForwardedTraffic = false,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         PeeringName = "vNetPeeringTest",
 *         RemoteVirtualNetwork = new AzureNative.Databricks.Inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs
 *         {
 *             Id = "/subscriptions/0140911e-1040-48da-8bc9-b99fb3dd88a6/resourceGroups/subramantest/providers/Microsoft.Network/virtualNetworks/subramanvnet",
 *         },
 *         ResourceGroupName = "rg",
 *         UseRemoteGateways = false,
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewVNetPeering(ctx, "vNetPeering", &databricks.VNetPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(false),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			PeeringName:               pulumi.String("vNetPeeringTest"),
 * 			RemoteVirtualNetwork: &databricks.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs{
 * 				Id: pulumi.String("/subscriptions/0140911e-1040-48da-8bc9-b99fb3dd88a6/resourceGroups/subramantest/providers/Microsoft.Network/virtualNetworks/subramanvnet"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			UseRemoteGateways: pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.VNetPeering;
 * import com.pulumi.azurenative.databricks.VNetPeeringArgs;
 * import com.pulumi.azurenative.databricks.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vNetPeering = new VNetPeering("vNetPeering", VNetPeeringArgs.builder()
 *             .allowForwardedTraffic(false)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .peeringName("vNetPeeringTest")
 *             .remoteVirtualNetwork(VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs.builder()
 *                 .id("/subscriptions/0140911e-1040-48da-8bc9-b99fb3dd88a6/resourceGroups/subramantest/providers/Microsoft.Network/virtualNetworks/subramanvnet")
 *                 .build())
 *             .resourceGroupName("rg")
 *             .useRemoteGateways(false)
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databricks:VNetPeering vNetPeeringTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}/virtualNetworkPeerings/{peeringName}
 * ```
 */
public class VNetPeering internal constructor(
    override val javaResource: com.pulumi.azurenative.databricks.VNetPeering,
) : KotlinCustomResource(javaResource, VNetPeeringMapper) {
    /**
     * Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    public val allowForwardedTraffic: Output<Boolean>?
        get() = javaResource.allowForwardedTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    public val allowGatewayTransit: Output<Boolean>?
        get() = javaResource.allowGatewayTransit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    public val allowVirtualNetworkAccess: Output<Boolean>?
        get() = javaResource.allowVirtualNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The reference to the databricks virtual network address space.
     */
    public val databricksAddressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.databricksAddressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> addressSpaceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     *  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    public val databricksVirtualNetwork:
        Output<VirtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetwork>?
        get() = javaResource.databricksVirtualNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetworkToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name of the virtual network peering resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the virtual network peering.
     */
    public val peeringState: Output<String>
        get() = javaResource.peeringState().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the virtual network peering resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The reference to the remote virtual network address space.
     */
    public val remoteAddressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.remoteAddressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> addressSpaceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     *  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    public val remoteVirtualNetwork:
        Output<VirtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetwork>
        get() = javaResource.remoteVirtualNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetworkToKotlin(args0)
            })
        })

    /**
     * type of the virtual network peering resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    public val useRemoteGateways: Output<Boolean>?
        get() = javaResource.useRemoteGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VNetPeeringMapper : ResourceMapper<VNetPeering> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databricks.VNetPeering::class == javaResource::class

    override fun map(javaResource: Resource): VNetPeering = VNetPeering(
        javaResource as
            com.pulumi.azurenative.databricks.VNetPeering,
    )
}

/**
 * @see [VNetPeering].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VNetPeering].
 */
public suspend fun vNetPeering(name: String, block: suspend VNetPeeringResourceBuilder.() -> Unit):
    VNetPeering {
    val builder = VNetPeeringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VNetPeering].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vNetPeering(name: String): VNetPeering {
    val builder = VNetPeeringResourceBuilder()
    builder.name(name)
    return builder.build()
}
