@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin

import com.pulumi.azurenative.databricks.WorkspaceArgs.builder
import com.pulumi.azurenative.databricks.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.databricks.kotlin.enums.RequiredNsgRules
import com.pulumi.azurenative.databricks.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.WorkspaceCustomParametersArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.WorkspaceCustomParametersArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.WorkspacePropertiesEncryptionArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.WorkspacePropertiesEncryptionArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.WorkspaceProviderAuthorizationArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.WorkspaceProviderAuthorizationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about workspace.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2018-04-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create a workspace which is ready for Customer-Managed Key (CMK) encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             PrepareEncryption = new AzureNative.Databricks.Inputs.WorkspaceCustomBooleanParameterArgs
 *             {
 *                 Value = true,
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			Parameters: &databricks.WorkspaceCustomParametersArgs{
 * 				PrepareEncryption: &databricks.WorkspaceCustomBooleanParameterArgs{
 * 					Value: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomBooleanParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(WorkspaceCustomParametersArgs.builder()
 *                 .prepareEncryption(WorkspaceCustomBooleanParameterArgs.builder()
 *                     .value(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workspace with Customer-Managed Key (CMK) encryption for Managed Disks
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Encryption = new AzureNative.Databricks.Inputs.WorkspacePropertiesEncryptionArgs
 *         {
 *             Entities = new AzureNative.Databricks.Inputs.EncryptionEntitiesDefinitionArgs
 *             {
 *                 ManagedDisk = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionArgs
 *                 {
 *                     KeySource = AzureNative.Databricks.EncryptionKeySource.Microsoft_Keyvault,
 *                     KeyVaultProperties = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs
 *                     {
 *                         KeyName = "test-cmk-key",
 *                         KeyVaultUri = "https://test-vault-name.vault.azure.net/",
 *                         KeyVersion = "00000000000000000000000000000000",
 *                     },
 *                     RotationToLatestKeyVersionEnabled = true,
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Encryption: &databricks.WorkspacePropertiesEncryptionArgs{
 * 				Entities: &databricks.EncryptionEntitiesDefinitionArgs{
 * 					ManagedDisk: &databricks.ManagedDiskEncryptionArgs{
 * 						KeySource: pulumi.String(databricks.EncryptionKeySource_Microsoft_Keyvault),
 * 						KeyVaultProperties: &databricks.ManagedDiskEncryptionKeyVaultPropertiesArgs{
 * 							KeyName:     pulumi.String("test-cmk-key"),
 * 							KeyVaultUri: pulumi.String("https://test-vault-name.vault.azure.net/"),
 * 							KeyVersion:  pulumi.String("00000000000000000000000000000000"),
 * 						},
 * 						RotationToLatestKeyVersionEnabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			WorkspaceName:          pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspacePropertiesEncryptionArgs;
 * import com.pulumi.azurenative.databricks.inputs.EncryptionEntitiesDefinitionArgs;
 * import com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionArgs;
 * import com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .encryption(WorkspacePropertiesEncryptionArgs.builder()
 *                 .entities(EncryptionEntitiesDefinitionArgs.builder()
 *                     .managedDisk(ManagedDiskEncryptionArgs.builder()
 *                         .keySource("Microsoft.Keyvault")
 *                         .keyVaultProperties(ManagedDiskEncryptionKeyVaultPropertiesArgs.builder()
 *                             .keyName("test-cmk-key")
 *                             .keyVaultUri("https://test-vault-name.vault.azure.net/")
 *                             .keyVersion("00000000000000000000000000000000")
 *                             .build())
 *                         .rotationToLatestKeyVersionEnabled(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			WorkspaceName:          pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update workspace with custom parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             CustomPrivateSubnetName = new AzureNative.Databricks.Inputs.WorkspaceCustomStringParameterArgs
 *             {
 *                 Value = "myPrivateSubnet",
 *             },
 *             CustomPublicSubnetName = new AzureNative.Databricks.Inputs.WorkspaceCustomStringParameterArgs
 *             {
 *                 Value = "myPublicSubnet",
 *             },
 *             CustomVirtualNetworkId = new AzureNative.Databricks.Inputs.WorkspaceCustomStringParameterArgs
 *             {
 *                 Value = "/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork",
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			Parameters: &databricks.WorkspaceCustomParametersArgs{
 * 				CustomPrivateSubnetName: &databricks.WorkspaceCustomStringParameterArgs{
 * 					Value: pulumi.String("myPrivateSubnet"),
 * 				},
 * 				CustomPublicSubnetName: &databricks.WorkspaceCustomStringParameterArgs{
 * 					Value: pulumi.String("myPublicSubnet"),
 * 				},
 * 				CustomVirtualNetworkId: &databricks.WorkspaceCustomStringParameterArgs{
 * 					Value: pulumi.String("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomStringParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(WorkspaceCustomParametersArgs.builder()
 *                 .customPrivateSubnetName(WorkspaceCustomStringParameterArgs.builder()
 *                     .value("myPrivateSubnet")
 *                     .build())
 *                 .customPublicSubnetName(WorkspaceCustomStringParameterArgs.builder()
 *                     .value("myPublicSubnet")
 *                     .build())
 *                 .customVirtualNetworkId(WorkspaceCustomStringParameterArgs.builder()
 *                     .value("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Customer-Managed Key (CMK) encryption on a workspace which is prepared for encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             Encryption = new AzureNative.Databricks.Inputs.WorkspaceEncryptionParameterArgs
 *             {
 *                 Value = new AzureNative.Databricks.Inputs.EncryptionArgs
 *                 {
 *                     KeyName = "myKeyName",
 *                     KeySource = AzureNative.Databricks.KeySource.Microsoft_Keyvault,
 *                     KeyVaultUri = "https://myKeyVault.vault.azure.net/",
 *                     KeyVersion = "00000000000000000000000000000000",
 *                 },
 *             },
 *             PrepareEncryption = new AzureNative.Databricks.Inputs.WorkspaceCustomBooleanParameterArgs
 *             {
 *                 Value = true,
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			Parameters: &databricks.WorkspaceCustomParametersArgs{
 * 				Encryption: &databricks.WorkspaceEncryptionParameterArgs{
 * 					Value: &databricks.EncryptionArgs{
 * 						KeyName:     pulumi.String("myKeyName"),
 * 						KeySource:   pulumi.String(databricks.KeySource_Microsoft_Keyvault),
 * 						KeyVaultUri: pulumi.String("https://myKeyVault.vault.azure.net/"),
 * 						KeyVersion:  pulumi.String("00000000000000000000000000000000"),
 * 					},
 * 				},
 * 				PrepareEncryption: &databricks.WorkspaceCustomBooleanParameterArgs{
 * 					Value: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceEncryptionParameterArgs;
 * import com.pulumi.azurenative.databricks.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomBooleanParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(WorkspaceCustomParametersArgs.builder()
 *                 .encryption(WorkspaceEncryptionParameterArgs.builder()
 *                     .value(EncryptionArgs.builder()
 *                         .keyName("myKeyName")
 *                         .keySource("Microsoft.Keyvault")
 *                         .keyVaultUri("https://myKeyVault.vault.azure.net/")
 *                         .keyVersion("00000000000000000000000000000000")
 *                         .build())
 *                     .build())
 *                 .prepareEncryption(WorkspaceCustomBooleanParameterArgs.builder()
 *                     .value(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Revert Customer-Managed Key (CMK) encryption to Microsoft Managed Keys encryption on a workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             Encryption = new AzureNative.Databricks.Inputs.WorkspaceEncryptionParameterArgs
 *             {
 *                 Value = new AzureNative.Databricks.Inputs.EncryptionArgs
 *                 {
 *                     KeySource = AzureNative.Databricks.KeySource.Default,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			Parameters: &databricks.WorkspaceCustomParametersArgs{
 * 				Encryption: &databricks.WorkspaceEncryptionParameterArgs{
 * 					Value: &databricks.EncryptionArgs{
 * 						KeySource: pulumi.String(databricks.KeySourceDefault),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspaceEncryptionParameterArgs;
 * import com.pulumi.azurenative.databricks.inputs.EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(WorkspaceCustomParametersArgs.builder()
 *                 .encryption(WorkspaceEncryptionParameterArgs.builder()
 *                     .value(EncryptionArgs.builder()
 *                         .keySource("Default")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a workspace with Customer-Managed Key (CMK) encryption for Managed Disks
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Encryption = new AzureNative.Databricks.Inputs.WorkspacePropertiesEncryptionArgs
 *         {
 *             Entities = new AzureNative.Databricks.Inputs.EncryptionEntitiesDefinitionArgs
 *             {
 *                 ManagedDisk = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionArgs
 *                 {
 *                     KeySource = AzureNative.Databricks.EncryptionKeySource.Microsoft_Keyvault,
 *                     KeyVaultProperties = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs
 *                     {
 *                         KeyName = "test-cmk-key",
 *                         KeyVaultUri = "https://test-vault-name.vault.azure.net/",
 *                         KeyVersion = "00000000000000000000000000000000",
 *                     },
 *                     RotationToLatestKeyVersionEnabled = true,
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *         Tags =
 *         {
 *             { "mytag1", "myvalue1" },
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Encryption: &databricks.WorkspacePropertiesEncryptionArgs{
 * 				Entities: &databricks.EncryptionEntitiesDefinitionArgs{
 * 					ManagedDisk: &databricks.ManagedDiskEncryptionArgs{
 * 						KeySource: pulumi.String(databricks.EncryptionKeySource_Microsoft_Keyvault),
 * 						KeyVaultProperties: &databricks.ManagedDiskEncryptionKeyVaultPropertiesArgs{
 * 							KeyName:     pulumi.String("test-cmk-key"),
 * 							KeyVaultUri: pulumi.String("https://test-vault-name.vault.azure.net/"),
 * 							KeyVersion:  pulumi.String("00000000000000000000000000000000"),
 * 						},
 * 						RotationToLatestKeyVersionEnabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag1": pulumi.String("myvalue1"),
 * 			},
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import com.pulumi.azurenative.databricks.inputs.WorkspacePropertiesEncryptionArgs;
 * import com.pulumi.azurenative.databricks.inputs.EncryptionEntitiesDefinitionArgs;
 * import com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionArgs;
 * import com.pulumi.azurenative.databricks.inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .encryption(WorkspacePropertiesEncryptionArgs.builder()
 *                 .entities(EncryptionEntitiesDefinitionArgs.builder()
 *                     .managedDisk(ManagedDiskEncryptionArgs.builder()
 *                         .keySource("Microsoft.Keyvault")
 *                         .keyVaultProperties(ManagedDiskEncryptionKeyVaultPropertiesArgs.builder()
 *                             .keyName("test-cmk-key")
 *                             .keyVaultUri("https://test-vault-name.vault.azure.net/")
 *                             .keyVersion("00000000000000000000000000000000")
 *                             .build())
 *                         .rotationToLatestKeyVersionEnabled(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .tags(Map.of("mytag1", "myvalue1"))
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databricks:Workspace myWorkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}
 * ```
 * @property authorizations The workspace provider authorizations.
 * @property encryption Encryption properties for databricks workspace
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupId The managed resource group Id.
 * @property parameters The workspace's custom parameters.
 * @property publicNetworkAccess The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
 * @property requiredNsgRules Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of the resource.
 * @property tags Resource tags.
 * @property uiDefinitionUri The blob URI where the UI definition file is located.
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceArgs(
    public val authorizations: Output<List<WorkspaceProviderAuthorizationArgs>>? = null,
    public val encryption: Output<WorkspacePropertiesEncryptionArgs>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupId: Output<String>? = null,
    public val parameters: Output<WorkspaceCustomParametersArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val requiredNsgRules: Output<Either<String, RequiredNsgRules>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uiDefinitionUri: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.WorkspaceArgs =
        com.pulumi.azurenative.databricks.WorkspaceArgs.builder()
            .authorizations(
                authorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupId(managedResourceGroupId?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .requiredNsgRules(
                requiredNsgRules?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uiDefinitionUri(uiDefinitionUri?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var authorizations: Output<List<WorkspaceProviderAuthorizationArgs>>? = null

    private var encryption: Output<WorkspacePropertiesEncryptionArgs>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupId: Output<String>? = null

    private var parameters: Output<WorkspaceCustomParametersArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var requiredNsgRules: Output<Either<String, RequiredNsgRules>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uiDefinitionUri: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The workspace provider authorizations.
     */
    @JvmName("crplgrpvhsoiqiqq")
    public suspend fun authorizations(`value`: Output<List<WorkspaceProviderAuthorizationArgs>>) {
        this.authorizations = value
    }

    @JvmName("bqmtqoyhiunogflt")
    public suspend fun authorizations(vararg values: Output<WorkspaceProviderAuthorizationArgs>) {
        this.authorizations = Output.all(values.asList())
    }

    /**
     * @param values The workspace provider authorizations.
     */
    @JvmName("pyioxfgsylglefwc")
    public suspend fun authorizations(values: List<Output<WorkspaceProviderAuthorizationArgs>>) {
        this.authorizations = Output.all(values)
    }

    /**
     * @param value Encryption properties for databricks workspace
     */
    @JvmName("remndqydmctltshm")
    public suspend fun encryption(`value`: Output<WorkspacePropertiesEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yxklqklwatglsdsi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The managed resource group Id.
     */
    @JvmName("fnvguqegobkkjtuv")
    public suspend fun managedResourceGroupId(`value`: Output<String>) {
        this.managedResourceGroupId = value
    }

    /**
     * @param value The workspace's custom parameters.
     */
    @JvmName("cwwhroecagxgppuk")
    public suspend fun parameters(`value`: Output<WorkspaceCustomParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
     */
    @JvmName("dwcuuaypeclnefjo")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
     */
    @JvmName("pylaaiemfwlbyxkg")
    public suspend fun requiredNsgRules(`value`: Output<Either<String, RequiredNsgRules>>) {
        this.requiredNsgRules = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wjkrmqylijoikneb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("bvrbsgdmtrakdwqu")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ogaaayakhmxxqwpp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The blob URI where the UI definition file is located.
     */
    @JvmName("vkmivrdtopbcvpxh")
    public suspend fun uiDefinitionUri(`value`: Output<String>) {
        this.uiDefinitionUri = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wecucmqmoryojkav")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The workspace provider authorizations.
     */
    @JvmName("yulcpikytrsyddyk")
    public suspend fun authorizations(`value`: List<WorkspaceProviderAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param argument The workspace provider authorizations.
     */
    @JvmName("gmxitnvfipplbvls")
    public suspend
    fun authorizations(argument: List<suspend WorkspaceProviderAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkspaceProviderAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The workspace provider authorizations.
     */
    @JvmName("tfkyuecynhjhlfab")
    public suspend fun authorizations(
        vararg
        argument: suspend WorkspaceProviderAuthorizationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkspaceProviderAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument The workspace provider authorizations.
     */
    @JvmName("pyaeugtptuasmoqh")
    public suspend
    fun authorizations(argument: suspend WorkspaceProviderAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkspaceProviderAuthorizationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param values The workspace provider authorizations.
     */
    @JvmName("txyvkrnpihmwqocn")
    public suspend fun authorizations(vararg values: WorkspaceProviderAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param value Encryption properties for databricks workspace
     */
    @JvmName("vmllkgdkcwpjwffd")
    public suspend fun encryption(`value`: WorkspacePropertiesEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption properties for databricks workspace
     */
    @JvmName("uclpaeovgxtpxvyj")
    public suspend
    fun encryption(argument: suspend WorkspacePropertiesEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspacePropertiesEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gyapswrupdbahbwl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The managed resource group Id.
     */
    @JvmName("oikxtwulhjrfyxmd")
    public suspend fun managedResourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupId = mapped
    }

    /**
     * @param value The workspace's custom parameters.
     */
    @JvmName("syydbhpghwflmguf")
    public suspend fun parameters(`value`: WorkspaceCustomParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The workspace's custom parameters.
     */
    @JvmName("jbvmkoegphvdruab")
    public suspend fun parameters(argument: suspend WorkspaceCustomParametersArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
     */
    @JvmName("swwpyjjqglggcfrh")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
     */
    @JvmName("hcvhcnodfqnfmypx")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
     */
    @JvmName("mwcmgaiqhfjgthru")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
     */
    @JvmName("bdojjcpfhcjdrouy")
    public suspend fun requiredNsgRules(`value`: Either<String, RequiredNsgRules>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredNsgRules = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
     */
    @JvmName("qvyxglgfoxcbomqc")
    public fun requiredNsgRules(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RequiredNsgRules>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredNsgRules = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
     */
    @JvmName("nlpmgdaqukauvwgk")
    public fun requiredNsgRules(`value`: RequiredNsgRules) {
        val toBeMapped = Either.ofRight<String, RequiredNsgRules>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredNsgRules = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("egrfcwxgfvcbqxsq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the resource.
     */
    @JvmName("dwkudyvlomomaayi")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the resource.
     */
    @JvmName("nyxrrpidpjqsyqhm")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rihbhwlrkulwhgah")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rdsoxaaamawinqux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The blob URI where the UI definition file is located.
     */
    @JvmName("ybetkplrhoebqsrx")
    public suspend fun uiDefinitionUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uiDefinitionUri = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mcljdvovplqcgrho")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        authorizations = authorizations,
        encryption = encryption,
        location = location,
        managedResourceGroupId = managedResourceGroupId,
        parameters = parameters,
        publicNetworkAccess = publicNetworkAccess,
        requiredNsgRules = requiredNsgRules,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        uiDefinitionUri = uiDefinitionUri,
        workspaceName = workspaceName,
    )
}
