@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomBooleanParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The value which should be used for this field.
 * @property value The value which should be used for this field.
 */
public data class WorkspaceCustomBooleanParameterArgs(
    public val `value`: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.WorkspaceCustomBooleanParameterArgs> {
    override fun toJava():
        com.pulumi.azurenative.databricks.inputs.WorkspaceCustomBooleanParameterArgs =
        com.pulumi.azurenative.databricks.inputs.WorkspaceCustomBooleanParameterArgs.builder()
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceCustomBooleanParameterArgs].
 */
@PulumiTagMarker
public class WorkspaceCustomBooleanParameterArgsBuilder internal constructor() {
    private var `value`: Output<Boolean>? = null

    /**
     * @param value The value which should be used for this field.
     */
    @JvmName("andkwwqweptxncya")
    public suspend fun `value`(`value`: Output<Boolean>) {
        this.`value` = value
    }

    /**
     * @param value The value which should be used for this field.
     */
    @JvmName("brqgwjekmelgkhkw")
    public suspend fun `value`(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WorkspaceCustomBooleanParameterArgs = WorkspaceCustomBooleanParameterArgs(
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
