@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The object that contains details of encryption used on the workspace.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Keyvault
 * @property keyVaultProperties Key Vault input properties for encryption.
 */
public data class EncryptionV2Response(
    public val keySource: String,
    public val keyVaultProperties: EncryptionV2ResponseKeyVaultProperties? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.EncryptionV2Response):
            EncryptionV2Response = EncryptionV2Response(
            keySource = javaType.keySource(),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.EncryptionV2ResponseKeyVaultProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
