@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key Vault input properties for encryption.
 * @property keyName The name of KeyVault key.
 * @property keyVaultUri The URI of KeyVault.
 * @property keyVersion The version of KeyVault key.
 */
public data class ManagedDiskEncryptionResponseKeyVaultProperties(
    public val keyName: String,
    public val keyVaultUri: String,
    public val keyVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.ManagedDiskEncryptionResponseKeyVaultProperties):
            ManagedDiskEncryptionResponseKeyVaultProperties =
            ManagedDiskEncryptionResponseKeyVaultProperties(
                keyName = javaType.keyName(),
                keyVaultUri = javaType.keyVaultUri(),
                keyVersion = javaType.keyVersion(),
            )
    }
}
