@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.Suppress

/**
 * Custom Parameters used for Cluster Creation.
 * @property amlWorkspaceId The ID of a Azure Machine Learning workspace to link with Databricks workspace
 * @property customPrivateSubnetName The name of the Private Subnet within the Virtual Network
 * @property customPublicSubnetName The name of a Public Subnet within the Virtual Network
 * @property customVirtualNetworkId The ID of a Virtual Network where this Databricks Cluster should be created
 * @property enableNoPublicIp Should the Public IP be Disabled?
 * @property encryption Contains the encryption details for Customer-Managed Key (CMK) enabled workspace.
 * @property loadBalancerBackendPoolName Name of the outbound Load Balancer Backend Pool for Secure Cluster Connectivity (No Public IP).
 * @property loadBalancerId Resource URI of Outbound Load balancer for Secure Cluster Connectivity (No Public IP) workspace.
 * @property natGatewayName Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets.
 * @property prepareEncryption Prepare the workspace for encryption. Enables the Managed Identity for managed storage account.
 * @property publicIpName Name of the Public IP for No Public IP workspace with managed vNet.
 * @property requireInfrastructureEncryption A boolean indicating whether or not the DBFS root file system will be enabled with secondary layer of encryption with platform managed keys for data at rest.
 * @property resourceTags Tags applied to resources under Managed resource group. These can be updated by updating tags at workspace level.
 * @property storageAccountName Default DBFS storage account name.
 * @property storageAccountSkuName Storage account SKU name, ex: Standard_GRS, Standard_LRS. Refer https://aka.ms/storageskus for valid inputs.
 * @property vnetAddressPrefix Address prefix for Managed virtual network. Default value for this input is 10.139.
 */
public data class WorkspaceCustomParametersResponse(
    public val amlWorkspaceId: WorkspaceCustomStringParameterResponse? = null,
    public val customPrivateSubnetName: WorkspaceCustomStringParameterResponse? = null,
    public val customPublicSubnetName: WorkspaceCustomStringParameterResponse? = null,
    public val customVirtualNetworkId: WorkspaceCustomStringParameterResponse? = null,
    public val enableNoPublicIp: WorkspaceCustomBooleanParameterResponse? = null,
    public val encryption: WorkspaceEncryptionParameterResponse? = null,
    public val loadBalancerBackendPoolName: WorkspaceCustomStringParameterResponse? = null,
    public val loadBalancerId: WorkspaceCustomStringParameterResponse? = null,
    public val natGatewayName: WorkspaceCustomStringParameterResponse? = null,
    public val prepareEncryption: WorkspaceCustomBooleanParameterResponse? = null,
    public val publicIpName: WorkspaceCustomStringParameterResponse? = null,
    public val requireInfrastructureEncryption: WorkspaceCustomBooleanParameterResponse? = null,
    public val resourceTags: WorkspaceCustomObjectParameterResponse,
    public val storageAccountName: WorkspaceCustomStringParameterResponse? = null,
    public val storageAccountSkuName: WorkspaceCustomStringParameterResponse? = null,
    public val vnetAddressPrefix: WorkspaceCustomStringParameterResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.WorkspaceCustomParametersResponse):
            WorkspaceCustomParametersResponse = WorkspaceCustomParametersResponse(
            amlWorkspaceId = javaType.amlWorkspaceId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customPrivateSubnetName = javaType.customPrivateSubnetName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customPublicSubnetName = javaType.customPublicSubnetName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customVirtualNetworkId = javaType.customVirtualNetworkId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableNoPublicIp = javaType.enableNoPublicIp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomBooleanParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceEncryptionParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loadBalancerBackendPoolName = javaType.loadBalancerBackendPoolName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loadBalancerId = javaType.loadBalancerId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            natGatewayName = javaType.natGatewayName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            prepareEncryption = javaType.prepareEncryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomBooleanParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            publicIpName = javaType.publicIpName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requireInfrastructureEncryption = javaType.requireInfrastructureEncryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomBooleanParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceTags = javaType.resourceTags().let({ args0 ->
                com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomObjectParameterResponse.Companion.toKotlin(args0)
            }),
            storageAccountName = javaType.storageAccountName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountSkuName = javaType.storageAccountSkuName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vnetAddressPrefix = javaType.vnetAddressPrefix().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomStringParameterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
