@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin

import com.pulumi.azurenative.datacatalog.kotlin.outputs.PrincipalsResponse
import com.pulumi.azurenative.datacatalog.kotlin.outputs.PrincipalsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ADCCatalog].
 */
@PulumiTagMarker
public class ADCCatalogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ADCCatalogArgs = ADCCatalogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ADCCatalogArgsBuilder.() -> Unit) {
        val builder = ADCCatalogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ADCCatalog {
        val builtJavaResource = com.pulumi.azurenative.datacatalog.ADCCatalog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ADCCatalog(builtJavaResource)
    }
}

/**
 * Azure Data Catalog.
 * Azure REST API version: 2016-03-30. Prior API version in Azure Native 1.x: 2016-03-30.
 * ## Example Usage
 * ### Create Azure Data Catalog Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adcCatalog = new AzureNative.DataCatalog.ADCCatalog("adcCatalog", new()
 *     {
 *         Admins = new[]
 *         {
 *             new AzureNative.DataCatalog.Inputs.PrincipalsArgs
 *             {
 *                 ObjectId = "99999999-9999-9999-999999999999",
 *                 Upn = "myupn@microsoft.com",
 *             },
 *         },
 *         CatalogName = "exampleCatalog",
 *         EnableAutomaticUnitAdjustment = false,
 *         Location = "North US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Sku = AzureNative.DataCatalog.SkuType.Standard,
 *         Tags =
 *         {
 *             { "mykey", "myvalue" },
 *             { "mykey2", "myvalue2" },
 *         },
 *         Units = 1,
 *         Users = new[]
 *         {
 *             new AzureNative.DataCatalog.Inputs.PrincipalsArgs
 *             {
 *                 ObjectId = "99999999-9999-9999-999999999999",
 *                 Upn = "myupn@microsoft.com",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datacatalog/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datacatalog.NewADCCatalog(ctx, "adcCatalog", &datacatalog.ADCCatalogArgs{
 * 			Admins: datacatalog.PrincipalsArray{
 * 				&datacatalog.PrincipalsArgs{
 * 					ObjectId: pulumi.String("99999999-9999-9999-999999999999"),
 * 					Upn:      pulumi.String("myupn@microsoft.com"),
 * 				},
 * 			},
 * 			CatalogName:                   pulumi.String("exampleCatalog"),
 * 			EnableAutomaticUnitAdjustment: pulumi.Bool(false),
 * 			Location:                      pulumi.String("North US"),
 * 			ResourceGroupName:             pulumi.String("exampleResourceGroup"),
 * 			Sku:                           pulumi.String(datacatalog.SkuTypeStandard),
 * 			Tags: pulumi.StringMap{
 * 				"mykey":  pulumi.String("myvalue"),
 * 				"mykey2": pulumi.String("myvalue2"),
 * 			},
 * 			Units: pulumi.Int(1),
 * 			Users: datacatalog.PrincipalsArray{
 * 				&datacatalog.PrincipalsArgs{
 * 					ObjectId: pulumi.String("99999999-9999-9999-999999999999"),
 * 					Upn:      pulumi.String("myupn@microsoft.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datacatalog.ADCCatalog;
 * import com.pulumi.azurenative.datacatalog.ADCCatalogArgs;
 * import com.pulumi.azurenative.datacatalog.inputs.PrincipalsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adcCatalog = new ADCCatalog("adcCatalog", ADCCatalogArgs.builder()
 *             .admins(PrincipalsArgs.builder()
 *                 .objectId("99999999-9999-9999-999999999999")
 *                 .upn("myupn@microsoft.com")
 *                 .build())
 *             .catalogName("exampleCatalog")
 *             .enableAutomaticUnitAdjustment(false)
 *             .location("North US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .sku("Standard")
 *             .tags(Map.ofEntries(
 *                 Map.entry("mykey", "myvalue"),
 *                 Map.entry("mykey2", "myvalue2")
 *             ))
 *             .units(1)
 *             .users(PrincipalsArgs.builder()
 *                 .objectId("99999999-9999-9999-999999999999")
 *                 .upn("myupn@microsoft.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datacatalog:ADCCatalog exampleCatalog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}
 * ```
 */
public class ADCCatalog internal constructor(
    override val javaResource: com.pulumi.azurenative.datacatalog.ADCCatalog,
) : KotlinCustomResource(javaResource, ADCCatalogMapper) {
    /**
     * Azure data catalog admin list.
     */
    public val admins: Output<List<PrincipalsResponse>>?
        get() = javaResource.admins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Automatic unit adjustment enabled or not.
     */
    public val enableAutomaticUnitAdjustment: Output<Boolean>?
        get() = javaResource.enableAutomaticUnitAdjustment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource etag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure data catalog SKU.
     */
    public val sku: Output<String>?
        get() = javaResource.sku().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure data catalog provision status.
     */
    public val successfullyProvisioned: Output<Boolean>?
        get() = javaResource.successfullyProvisioned().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Azure data catalog units.
     */
    public val units: Output<Int>?
        get() = javaResource.units().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure data catalog user list.
     */
    public val users: Output<List<PrincipalsResponse>>?
        get() = javaResource.users().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object ADCCatalogMapper : ResourceMapper<ADCCatalog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datacatalog.ADCCatalog::class == javaResource::class

    override fun map(javaResource: Resource): ADCCatalog = ADCCatalog(
        javaResource as
            com.pulumi.azurenative.datacatalog.ADCCatalog,
    )
}

/**
 * @see [ADCCatalog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ADCCatalog].
 */
public suspend fun adcCatalog(name: String, block: suspend ADCCatalogResourceBuilder.() -> Unit):
    ADCCatalog {
    val builder = ADCCatalogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ADCCatalog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun adcCatalog(name: String): ADCCatalog {
    val builder = ADCCatalogResourceBuilder()
    builder.name(name)
    return builder.build()
}
