@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin

import com.pulumi.azurenative.datacatalog.ADCCatalogArgs.builder
import com.pulumi.azurenative.datacatalog.kotlin.enums.SkuType
import com.pulumi.azurenative.datacatalog.kotlin.inputs.PrincipalsArgs
import com.pulumi.azurenative.datacatalog.kotlin.inputs.PrincipalsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Data Catalog.
 * Azure REST API version: 2016-03-30. Prior API version in Azure Native 1.x: 2016-03-30.
 * ## Example Usage
 * ### Create Azure Data Catalog Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adcCatalog = new AzureNative.DataCatalog.ADCCatalog("adcCatalog", new()
 *     {
 *         Admins = new[]
 *         {
 *             new AzureNative.DataCatalog.Inputs.PrincipalsArgs
 *             {
 *                 ObjectId = "99999999-9999-9999-999999999999",
 *                 Upn = "myupn@microsoft.com",
 *             },
 *         },
 *         CatalogName = "exampleCatalog",
 *         EnableAutomaticUnitAdjustment = false,
 *         Location = "North US",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Sku = AzureNative.DataCatalog.SkuType.Standard,
 *         Tags =
 *         {
 *             { "mykey", "myvalue" },
 *             { "mykey2", "myvalue2" },
 *         },
 *         Units = 1,
 *         Users = new[]
 *         {
 *             new AzureNative.DataCatalog.Inputs.PrincipalsArgs
 *             {
 *                 ObjectId = "99999999-9999-9999-999999999999",
 *                 Upn = "myupn@microsoft.com",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datacatalog/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datacatalog.NewADCCatalog(ctx, "adcCatalog", &datacatalog.ADCCatalogArgs{
 * 			Admins: datacatalog.PrincipalsArray{
 * 				&datacatalog.PrincipalsArgs{
 * 					ObjectId: pulumi.String("99999999-9999-9999-999999999999"),
 * 					Upn:      pulumi.String("myupn@microsoft.com"),
 * 				},
 * 			},
 * 			CatalogName:                   pulumi.String("exampleCatalog"),
 * 			EnableAutomaticUnitAdjustment: pulumi.Bool(false),
 * 			Location:                      pulumi.String("North US"),
 * 			ResourceGroupName:             pulumi.String("exampleResourceGroup"),
 * 			Sku:                           pulumi.String(datacatalog.SkuTypeStandard),
 * 			Tags: pulumi.StringMap{
 * 				"mykey":  pulumi.String("myvalue"),
 * 				"mykey2": pulumi.String("myvalue2"),
 * 			},
 * 			Units: pulumi.Int(1),
 * 			Users: datacatalog.PrincipalsArray{
 * 				&datacatalog.PrincipalsArgs{
 * 					ObjectId: pulumi.String("99999999-9999-9999-999999999999"),
 * 					Upn:      pulumi.String("myupn@microsoft.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datacatalog.ADCCatalog;
 * import com.pulumi.azurenative.datacatalog.ADCCatalogArgs;
 * import com.pulumi.azurenative.datacatalog.inputs.PrincipalsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adcCatalog = new ADCCatalog("adcCatalog", ADCCatalogArgs.builder()
 *             .admins(PrincipalsArgs.builder()
 *                 .objectId("99999999-9999-9999-999999999999")
 *                 .upn("myupn@microsoft.com")
 *                 .build())
 *             .catalogName("exampleCatalog")
 *             .enableAutomaticUnitAdjustment(false)
 *             .location("North US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .sku("Standard")
 *             .tags(Map.ofEntries(
 *                 Map.entry("mykey", "myvalue"),
 *                 Map.entry("mykey2", "myvalue2")
 *             ))
 *             .units(1)
 *             .users(PrincipalsArgs.builder()
 *                 .objectId("99999999-9999-9999-999999999999")
 *                 .upn("myupn@microsoft.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datacatalog:ADCCatalog exampleCatalog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataCatalog/catalogs/{catalogName}
 * ```
 * @property admins Azure data catalog admin list.
 * @property catalogName The name of the data catalog in the specified subscription and resource group.
 * @property enableAutomaticUnitAdjustment Automatic unit adjustment enabled or not.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property sku Azure data catalog SKU.
 * @property successfullyProvisioned Azure data catalog provision status.
 * @property tags Resource tags
 * @property units Azure data catalog units.
 * @property users Azure data catalog user list.
 */
public data class ADCCatalogArgs(
    public val admins: Output<List<PrincipalsArgs>>? = null,
    public val catalogName: Output<String>? = null,
    public val enableAutomaticUnitAdjustment: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<Either<String, SkuType>>? = null,
    public val successfullyProvisioned: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val units: Output<Int>? = null,
    public val users: Output<List<PrincipalsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datacatalog.ADCCatalogArgs> {
    override fun toJava(): com.pulumi.azurenative.datacatalog.ADCCatalogArgs =
        com.pulumi.azurenative.datacatalog.ADCCatalogArgs.builder()
            .admins(admins?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .enableAutomaticUnitAdjustment(enableAutomaticUnitAdjustment?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(
                sku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .successfullyProvisioned(successfullyProvisioned?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .units(units?.applyValue({ args0 -> args0 }))
            .users(
                users?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ADCCatalogArgs].
 */
@PulumiTagMarker
public class ADCCatalogArgsBuilder internal constructor() {
    private var admins: Output<List<PrincipalsArgs>>? = null

    private var catalogName: Output<String>? = null

    private var enableAutomaticUnitAdjustment: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<Either<String, SkuType>>? = null

    private var successfullyProvisioned: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var units: Output<Int>? = null

    private var users: Output<List<PrincipalsArgs>>? = null

    /**
     * @param value Azure data catalog admin list.
     */
    @JvmName("kmskrgtjbhvqhciy")
    public suspend fun admins(`value`: Output<List<PrincipalsArgs>>) {
        this.admins = value
    }

    @JvmName("yqtghjpxxvslxccm")
    public suspend fun admins(vararg values: Output<PrincipalsArgs>) {
        this.admins = Output.all(values.asList())
    }

    /**
     * @param values Azure data catalog admin list.
     */
    @JvmName("vfrkowtytbsdhxlj")
    public suspend fun admins(values: List<Output<PrincipalsArgs>>) {
        this.admins = Output.all(values)
    }

    /**
     * @param value The name of the data catalog in the specified subscription and resource group.
     */
    @JvmName("feokkfspnnvyddlj")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Automatic unit adjustment enabled or not.
     */
    @JvmName("sedvqjlbovuxetfr")
    public suspend fun enableAutomaticUnitAdjustment(`value`: Output<Boolean>) {
        this.enableAutomaticUnitAdjustment = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("lohrgwbalnbvdcir")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ooquwdjdfmqdtnxe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure data catalog SKU.
     */
    @JvmName("ggbnwqtdkjvatpdw")
    public suspend fun sku(`value`: Output<Either<String, SkuType>>) {
        this.sku = value
    }

    /**
     * @param value Azure data catalog provision status.
     */
    @JvmName("ihahvhlfonqiknff")
    public suspend fun successfullyProvisioned(`value`: Output<Boolean>) {
        this.successfullyProvisioned = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ogpqrrsttbaglnut")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Azure data catalog units.
     */
    @JvmName("flffuaaemmaomeqg")
    public suspend fun units(`value`: Output<Int>) {
        this.units = value
    }

    /**
     * @param value Azure data catalog user list.
     */
    @JvmName("whgeyhuenitbvkda")
    public suspend fun users(`value`: Output<List<PrincipalsArgs>>) {
        this.users = value
    }

    @JvmName("bisjffdgcelnalfs")
    public suspend fun users(vararg values: Output<PrincipalsArgs>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values Azure data catalog user list.
     */
    @JvmName("svxkolvyqfukuyax")
    public suspend fun users(values: List<Output<PrincipalsArgs>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value Azure data catalog admin list.
     */
    @JvmName("pywcvuynnljxoapi")
    public suspend fun admins(`value`: List<PrincipalsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.admins = mapped
    }

    /**
     * @param argument Azure data catalog admin list.
     */
    @JvmName("cbblfwbijarttnwe")
    public suspend fun admins(argument: List<suspend PrincipalsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PrincipalsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.admins = mapped
    }

    /**
     * @param argument Azure data catalog admin list.
     */
    @JvmName("newuhwrwcxgfdixu")
    public suspend fun admins(vararg argument: suspend PrincipalsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PrincipalsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.admins = mapped
    }

    /**
     * @param argument Azure data catalog admin list.
     */
    @JvmName("ojdhrlahuqllddri")
    public suspend fun admins(argument: suspend PrincipalsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrincipalsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.admins = mapped
    }

    /**
     * @param values Azure data catalog admin list.
     */
    @JvmName("pwvunxrpqxyjkqay")
    public suspend fun admins(vararg values: PrincipalsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.admins = mapped
    }

    /**
     * @param value The name of the data catalog in the specified subscription and resource group.
     */
    @JvmName("yetlsrlbealxbiio")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Automatic unit adjustment enabled or not.
     */
    @JvmName("qsickgmoptmlwdxl")
    public suspend fun enableAutomaticUnitAdjustment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUnitAdjustment = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("yabtdsbispvvfnsy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("cjvbehyduxmhgiyp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure data catalog SKU.
     */
    @JvmName("vnhoxfivxguvckym")
    public suspend fun sku(`value`: Either<String, SkuType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Azure data catalog SKU.
     */
    @JvmName("dfeiwwqggdbxotmu")
    public fun sku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Azure data catalog SKU.
     */
    @JvmName("kbbialahptqjuokb")
    public fun sku(`value`: SkuType) {
        val toBeMapped = Either.ofRight<String, SkuType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Azure data catalog provision status.
     */
    @JvmName("urehbjwfxvqquhyn")
    public suspend fun successfullyProvisioned(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successfullyProvisioned = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rdxpwmsuwrqauspr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("xqejbvpcnhgdshxr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Azure data catalog units.
     */
    @JvmName("vfvhqyoyusnslfui")
    public suspend fun units(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.units = mapped
    }

    /**
     * @param value Azure data catalog user list.
     */
    @JvmName("dkbyoffbbpdsynnd")
    public suspend fun users(`value`: List<PrincipalsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param argument Azure data catalog user list.
     */
    @JvmName("qqlnhaavdgkfhlsh")
    public suspend fun users(argument: List<suspend PrincipalsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PrincipalsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.users = mapped
    }

    /**
     * @param argument Azure data catalog user list.
     */
    @JvmName("mswtfkfaccxgiwmt")
    public suspend fun users(vararg argument: suspend PrincipalsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PrincipalsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.users = mapped
    }

    /**
     * @param argument Azure data catalog user list.
     */
    @JvmName("opvsxotjlmckgqxb")
    public suspend fun users(argument: suspend PrincipalsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrincipalsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.users = mapped
    }

    /**
     * @param values Azure data catalog user list.
     */
    @JvmName("msoqxmjpsuetrvtj")
    public suspend fun users(vararg values: PrincipalsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): ADCCatalogArgs = ADCCatalogArgs(
        admins = admins,
        catalogName = catalogName,
        enableAutomaticUnitAdjustment = enableAutomaticUnitAdjustment,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        successfullyProvisioned = successfullyProvisioned,
        tags = tags,
        units = units,
        users = users,
    )
}
