@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User principals.
 * @property objectId Object Id for the user
 * @property upn UPN of the user.
 */
public data class PrincipalsResponse(
    public val objectId: String? = null,
    public val upn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datacatalog.outputs.PrincipalsResponse):
            PrincipalsResponse = PrincipalsResponse(
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            upn = javaType.upn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
