@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin

import com.pulumi.azurenative.datadog.MonitorArgs.builder
import com.pulumi.azurenative.datadog.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.MonitorPropertiesArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.MonitorPropertiesArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2022-08-01, 2023-01-01.
 * ## Example Usage
 * ### Monitors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitor = new AzureNative.Datadog.Monitor("monitor", new()
 *     {
 *         Location = "West US",
 *         MonitorName = "myMonitor",
 *         Properties = new AzureNative.Datadog.Inputs.MonitorPropertiesArgs
 *         {
 *             DatadogOrganizationProperties = new AzureNative.Datadog.Inputs.DatadogOrganizationPropertiesArgs
 *             {
 *                 EnterpriseAppId = "00000000-0000-0000-0000-000000000000",
 *                 Id = "myOrg123",
 *                 LinkingAuthCode = "someAuthCode",
 *                 LinkingClientId = "00000000-0000-0000-0000-000000000000",
 *                 Name = "myOrg",
 *             },
 *             MonitoringStatus = AzureNative.Datadog.MonitoringStatus.Enabled,
 *             UserInfo = new AzureNative.Datadog.Inputs.UserInfoArgs
 *             {
 *                 EmailAddress = "alice@microsoft.com",
 *                 Name = "Alice",
 *                 PhoneNumber = "123-456-7890",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Datadog.Inputs.ResourceSkuArgs
 *         {
 *             Name = "free_Monthly",
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Dev" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datadog/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datadog.NewMonitor(ctx, "monitor", &datadog.MonitorArgs{
 * 			Location:    pulumi.String("West US"),
 * 			MonitorName: pulumi.String("myMonitor"),
 * 			Properties: &datadog.MonitorPropertiesArgs{
 * 				DatadogOrganizationProperties: &datadog.DatadogOrganizationPropertiesArgs{
 * 					EnterpriseAppId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					Id:              pulumi.String("myOrg123"),
 * 					LinkingAuthCode: pulumi.String("someAuthCode"),
 * 					LinkingClientId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 					Name:            pulumi.String("myOrg"),
 * 				},
 * 				MonitoringStatus: pulumi.String(datadog.MonitoringStatusEnabled),
 * 				UserInfo: &datadog.UserInfoArgs{
 * 					EmailAddress: pulumi.String("alice@microsoft.com"),
 * 					Name:         pulumi.String("Alice"),
 * 					PhoneNumber:  pulumi.String("123-456-7890"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &datadog.ResourceSkuArgs{
 * 				Name: pulumi.String("free_Monthly"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Dev"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datadog.Monitor;
 * import com.pulumi.azurenative.datadog.MonitorArgs;
 * import com.pulumi.azurenative.datadog.inputs.MonitorPropertiesArgs;
 * import com.pulumi.azurenative.datadog.inputs.DatadogOrganizationPropertiesArgs;
 * import com.pulumi.azurenative.datadog.inputs.UserInfoArgs;
 * import com.pulumi.azurenative.datadog.inputs.ResourceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitor = new Monitor("monitor", MonitorArgs.builder()
 *             .location("West US")
 *             .monitorName("myMonitor")
 *             .properties(MonitorPropertiesArgs.builder()
 *                 .datadogOrganizationProperties(DatadogOrganizationPropertiesArgs.builder()
 *                     .enterpriseAppId("00000000-0000-0000-0000-000000000000")
 *                     .id("myOrg123")
 *                     .linkingAuthCode("someAuthCode")
 *                     .linkingClientId("00000000-0000-0000-0000-000000000000")
 *                     .name("myOrg")
 *                     .build())
 *                 .monitoringStatus("Enabled")
 *                 .userInfo(UserInfoArgs.builder()
 *                     .emailAddress("alice@microsoft.com")
 *                     .name("Alice")
 *                     .phoneNumber("123-456-7890")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(ResourceSkuArgs.builder()
 *                 .name("free_Monthly")
 *                 .build())
 *             .tags(Map.of("Environment", "Dev"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datadog:Monitor myMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Datadog/monitors/{monitorName}
 * ```
 * @property identity
 * @property location
 * @property monitorName Monitor resource name
 * @property properties Properties specific to the monitor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku
 * @property tags
 */
public data class MonitorArgs(
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<MonitorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.MonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.MonitorArgs =
        com.pulumi.azurenative.datadog.MonitorArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitorArgs].
 */
@PulumiTagMarker
public class MonitorArgsBuilder internal constructor() {
    private var identity: Output<IdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<MonitorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("jgyfpypfkepebhke")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value
     */
    @JvmName("lykvlunlfxcglchd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("yrpxkdmigdyobsyh")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Properties specific to the monitor resource.
     */
    @JvmName("adslyjkaydoajaiy")
    public suspend fun properties(`value`: Output<MonitorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sjmqwvcpsjlvbblc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("ywarnfseojaprymd")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value
     */
    @JvmName("dhcsixgonhpafptj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("lbpswokfcaechbux")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cllppdqpxsnanpbn")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value
     */
    @JvmName("dmjwnmveopfhdido")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("gcsbxfkxdedcscog")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Properties specific to the monitor resource.
     */
    @JvmName("namitmsteewgyaef")
    public suspend fun properties(`value`: MonitorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties specific to the monitor resource.
     */
    @JvmName("cnesodmqgqdcdqwk")
    public suspend fun properties(argument: suspend MonitorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ptflbroxdldvpbvy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("keiruswxlxrwxyjb")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hqbrohbvpdqhptwa")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value
     */
    @JvmName("iboogfwesdwghvtj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("lfxeichepviuilun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitorArgs = MonitorArgs(
        identity = identity,
        location = location,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
