@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.DatadogOrganizationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Datadog organization properties
 * @property apiKey Api key associated to the Datadog organization.
 * @property applicationKey Application key associated to the Datadog organization.
 * @property enterpriseAppId The Id of the Enterprise App used for Single sign on.
 * @property id Id of the Datadog organization.
 * @property linkingAuthCode The auth code used to linking to an existing datadog organization.
 * @property linkingClientId The client_id from an existing in exchange for an auth token to link organization.
 * @property name Name of the Datadog organization.
 * @property redirectUri The redirect uri for linking.
 */
public data class DatadogOrganizationPropertiesArgs(
    public val apiKey: Output<String>? = null,
    public val applicationKey: Output<String>? = null,
    public val enterpriseAppId: Output<String>? = null,
    public val id: Output<String>? = null,
    public val linkingAuthCode: Output<String>? = null,
    public val linkingClientId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val redirectUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.DatadogOrganizationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.DatadogOrganizationPropertiesArgs =
        com.pulumi.azurenative.datadog.inputs.DatadogOrganizationPropertiesArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0 }))
            .applicationKey(applicationKey?.applyValue({ args0 -> args0 }))
            .enterpriseAppId(enterpriseAppId?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .linkingAuthCode(linkingAuthCode?.applyValue({ args0 -> args0 }))
            .linkingClientId(linkingClientId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .redirectUri(redirectUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatadogOrganizationPropertiesArgs].
 */
@PulumiTagMarker
public class DatadogOrganizationPropertiesArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    private var applicationKey: Output<String>? = null

    private var enterpriseAppId: Output<String>? = null

    private var id: Output<String>? = null

    private var linkingAuthCode: Output<String>? = null

    private var linkingClientId: Output<String>? = null

    private var name: Output<String>? = null

    private var redirectUri: Output<String>? = null

    /**
     * @param value Api key associated to the Datadog organization.
     */
    @JvmName("leatbkndttdvgvyr")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value Application key associated to the Datadog organization.
     */
    @JvmName("nqgjqhjiwlfdottg")
    public suspend fun applicationKey(`value`: Output<String>) {
        this.applicationKey = value
    }

    /**
     * @param value The Id of the Enterprise App used for Single sign on.
     */
    @JvmName("qsodkarsfunymiax")
    public suspend fun enterpriseAppId(`value`: Output<String>) {
        this.enterpriseAppId = value
    }

    /**
     * @param value Id of the Datadog organization.
     */
    @JvmName("qgymbgeqjloeesvg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The auth code used to linking to an existing datadog organization.
     */
    @JvmName("wnwfomgjgmerdbkl")
    public suspend fun linkingAuthCode(`value`: Output<String>) {
        this.linkingAuthCode = value
    }

    /**
     * @param value The client_id from an existing in exchange for an auth token to link organization.
     */
    @JvmName("rgujwgpyykdekixw")
    public suspend fun linkingClientId(`value`: Output<String>) {
        this.linkingClientId = value
    }

    /**
     * @param value Name of the Datadog organization.
     */
    @JvmName("mpaxhdvnbavufnep")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The redirect uri for linking.
     */
    @JvmName("rxjwrsmwskycsjil")
    public suspend fun redirectUri(`value`: Output<String>) {
        this.redirectUri = value
    }

    /**
     * @param value Api key associated to the Datadog organization.
     */
    @JvmName("ujrpxvjuagrubcme")
    public suspend fun apiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value Application key associated to the Datadog organization.
     */
    @JvmName("clbcpmnjdbsdpuao")
    public suspend fun applicationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationKey = mapped
    }

    /**
     * @param value The Id of the Enterprise App used for Single sign on.
     */
    @JvmName("amheflfmxraythtr")
    public suspend fun enterpriseAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterpriseAppId = mapped
    }

    /**
     * @param value Id of the Datadog organization.
     */
    @JvmName("pcjnyeofmglarggk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The auth code used to linking to an existing datadog organization.
     */
    @JvmName("grhvrqudrolganlo")
    public suspend fun linkingAuthCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkingAuthCode = mapped
    }

    /**
     * @param value The client_id from an existing in exchange for an auth token to link organization.
     */
    @JvmName("fcpjqlsnflhgghhx")
    public suspend fun linkingClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkingClientId = mapped
    }

    /**
     * @param value Name of the Datadog organization.
     */
    @JvmName("ogcwcjilyobajwst")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The redirect uri for linking.
     */
    @JvmName("hrdjxjhwsqhdsxgj")
    public suspend fun redirectUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUri = mapped
    }

    internal fun build(): DatadogOrganizationPropertiesArgs = DatadogOrganizationPropertiesArgs(
        apiKey = apiKey,
        applicationKey = applicationKey,
        enterpriseAppId = enterpriseAppId,
        id = id,
        linkingAuthCode = linkingAuthCode,
        linkingClientId = linkingClientId,
        name = name,
        redirectUri = redirectUri,
    )
}
