@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.MonitorPropertiesArgs.builder
import com.pulumi.azurenative.datadog.kotlin.enums.MonitoringStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties specific to the monitor resource.
 * @property datadogOrganizationProperties Datadog organization properties
 * @property monitoringStatus Flag specifying if the resource monitoring is enabled or disabled.
 * @property userInfo User info
 */
public data class MonitorPropertiesArgs(
    public val datadogOrganizationProperties: Output<DatadogOrganizationPropertiesArgs>? = null,
    public val monitoringStatus: Output<Either<String, MonitoringStatus>>? = null,
    public val userInfo: Output<UserInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.MonitorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.MonitorPropertiesArgs =
        com.pulumi.azurenative.datadog.inputs.MonitorPropertiesArgs.builder()
            .datadogOrganizationProperties(
                datadogOrganizationProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .monitoringStatus(
                monitoringStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .userInfo(userInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MonitorPropertiesArgs].
 */
@PulumiTagMarker
public class MonitorPropertiesArgsBuilder internal constructor() {
    private var datadogOrganizationProperties: Output<DatadogOrganizationPropertiesArgs>? = null

    private var monitoringStatus: Output<Either<String, MonitoringStatus>>? = null

    private var userInfo: Output<UserInfoArgs>? = null

    /**
     * @param value Datadog organization properties
     */
    @JvmName("ehbjbcmlxytnstsi")
    public suspend
    fun datadogOrganizationProperties(`value`: Output<DatadogOrganizationPropertiesArgs>) {
        this.datadogOrganizationProperties = value
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("xaqvjegcnfxlxwlu")
    public suspend fun monitoringStatus(`value`: Output<Either<String, MonitoringStatus>>) {
        this.monitoringStatus = value
    }

    /**
     * @param value User info
     */
    @JvmName("owtuyvivfiqwnfmi")
    public suspend fun userInfo(`value`: Output<UserInfoArgs>) {
        this.userInfo = value
    }

    /**
     * @param value Datadog organization properties
     */
    @JvmName("jfkpsjjoxwmcsttr")
    public suspend fun datadogOrganizationProperties(`value`: DatadogOrganizationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datadogOrganizationProperties = mapped
    }

    /**
     * @param argument Datadog organization properties
     */
    @JvmName("vnhakdtjwmrubadq")
    public suspend
    fun datadogOrganizationProperties(argument: suspend DatadogOrganizationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DatadogOrganizationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.datadogOrganizationProperties = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("niamngpsamklcmgg")
    public suspend fun monitoringStatus(`value`: Either<String, MonitoringStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("uwfvoofknmqqbcys")
    public fun monitoringStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("gqkhcneyxdatmoky")
    public fun monitoringStatus(`value`: MonitoringStatus) {
        val toBeMapped = Either.ofRight<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value User info
     */
    @JvmName("ptjshogwgmawotan")
    public suspend fun userInfo(`value`: UserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userInfo = mapped
    }

    /**
     * @param argument User info
     */
    @JvmName("wotvxrvjhaopmxsc")
    public suspend fun userInfo(argument: suspend UserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = UserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userInfo = mapped
    }

    internal fun build(): MonitorPropertiesArgs = MonitorPropertiesArgs(
        datadogOrganizationProperties = datadogOrganizationProperties,
        monitoringStatus = monitoringStatus,
        userInfo = userInfo,
    )
}
